/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micrometer.core.instrument.util.StringUtils;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import org.opensearch.dataprepper.http.HttpServerConfig;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;

public class BaseHttpServerConfig
implements HttpServerConfig {
    static final String COMPRESSION = "compression";
    static final String SSL = "ssl";
    static final String SSL_CERTIFICATE_FILE = "ssl_certificate_file";
    static final String SSL_KEY_FILE = "ssl_key_file";
    static final boolean DEFAULT_USE_ACM_CERTIFICATE_FOR_SSL = false;
    static final int DEFAULT_ACM_CERTIFICATE_TIMEOUT_MILLIS = 120000;
    static final int DEFAULT_REQUEST_TIMEOUT_MS = 10000;
    static final double BUFFER_TIMEOUT_FRACTION = 0.8;
    static final int DEFAULT_THREAD_COUNT = 200;
    static final int DEFAULT_MAX_CONNECTION_COUNT = 500;
    static final int DEFAULT_MAX_PENDING_REQUESTS = 1024;
    static final boolean DEFAULT_HEALTH_CHECK = false;
    static final String HEALTH_CHECK_SERVICE = "health_check_service";
    static final String UNAUTHENTICATED_HEALTH_CHECK = "unauthenticated_health_check";
    static final String S3_PREFIX = "s3://";
    @JsonProperty(value="port")
    @Min(value=0L)
    @Max(value=65535L)
    private @Min(value=0L) @Max(value=65535L) int port = this.getDefaultPort();
    @JsonProperty(value="path")
    @Size(min=1, message="path length should be at least 1")
    private @Size(min=1, message="path length should be at least 1") String path = this.getDefaultPath();
    @JsonProperty(value="request_timeout")
    @Min(value=2L)
    private @Min(value=2L) int requestTimeoutInMillis = 10000;
    @JsonProperty(value="thread_count")
    @Min(value=0L)
    private @Min(value=0L) int threadCount = 200;
    @JsonProperty(value="max_connection_count")
    @Min(value=0L)
    private @Min(value=0L) int maxConnectionCount = 500;
    @JsonProperty(value="max_pending_requests")
    @Min(value=0L)
    private @Min(value=0L) int maxPendingRequests = 1024;
    @JsonProperty(value="ssl")
    private boolean ssl;
    @JsonProperty(value="ssl_certificate_file")
    private String sslCertificateFile;
    @JsonProperty(value="ssl_key_file")
    private String sslKeyFile;
    @JsonProperty(value="use_acm_certificate_for_ssl")
    private boolean useAcmCertificateForSsl = false;
    @JsonProperty(value="acm_certificate_arn")
    private String acmCertificateArn;
    @JsonProperty(value="acm_private_key_password")
    private String acmPrivateKeyPassword;
    @JsonProperty(value="acm_certificate_timeout_millis")
    @Min(value=0L)
    private @Min(value=0L) Integer acmCertificateTimeoutMillis = 120000;
    @JsonProperty(value="aws_region")
    private String awsRegion;
    @JsonProperty(value="health_check_service")
    private boolean healthCheckService = false;
    @JsonProperty(value="unauthenticated_health_check")
    private boolean unauthenticatedHealthCheck = false;
    @JsonProperty(value="max_request_length")
    private ByteCount maxRequestLength;
    private PluginModel authentication;
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;

    @Override
    public int getDefaultPort() {
        return 0;
    }

    @Override
    public String getDefaultPath() {
        return "";
    }

    @Override
    @AssertTrue(message="path should start with /")
    public @AssertTrue(message="path should start with /") boolean isPathValid() {
        return this.path.startsWith("/");
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CompressionOption getCompression() {
        return this.compression;
    }

    @Override
    public boolean isSslCertAndKeyFileInS3() {
        return this.ssl && this.sslCertificateFile.toLowerCase().startsWith(S3_PREFIX) && this.sslKeyFile.toLowerCase().startsWith(S3_PREFIX);
    }

    @Override
    @AssertTrue(message="ssl_certificate_file cannot be a empty or null when ssl is enabled")
    public @AssertTrue(message="ssl_certificate_file cannot be a empty or null when ssl is enabled") boolean isSslCertificateFileValid() {
        if (this.ssl && !this.useAcmCertificateForSsl) {
            return StringUtils.isNotEmpty((String)this.sslCertificateFile);
        }
        return true;
    }

    @Override
    @AssertTrue(message="ssl_key_file cannot be a empty or null when ssl is enabled")
    public @AssertTrue(message="ssl_key_file cannot be a empty or null when ssl is enabled") boolean isSslKeyFileValid() {
        if (this.ssl && !this.useAcmCertificateForSsl) {
            return StringUtils.isNotEmpty((String)this.sslKeyFile);
        }
        return true;
    }

    @Override
    @AssertTrue(message="acm_certificate_arn cannot be a empty or null when ACM is used for ssl")
    public @AssertTrue(message="acm_certificate_arn cannot be a empty or null when ACM is used for ssl") boolean isAcmCertificateArnValid() {
        if (this.ssl && this.useAcmCertificateForSsl) {
            return StringUtils.isNotEmpty((String)this.acmCertificateArn);
        }
        return true;
    }

    @Override
    @AssertTrue(message="aws_region cannot be a empty or null when ACM / S3 is used for ssl")
    public @AssertTrue(message="aws_region cannot be a empty or null when ACM / S3 is used for ssl") boolean isAwsRegionValid() {
        if (this.ssl && (this.useAcmCertificateForSsl || this.isSslCertAndKeyFileInS3())) {
            return StringUtils.isNotEmpty((String)this.awsRegion);
        }
        return true;
    }

    @Override
    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    @Override
    public int getBufferTimeoutInMillis() {
        return (int)(0.8 * (double)this.requestTimeoutInMillis);
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    @Override
    public int getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public String getSslCertificateFile() {
        return this.sslCertificateFile;
    }

    @Override
    public String getSslKeyFile() {
        return this.sslKeyFile;
    }

    @Override
    public boolean isUseAcmCertificateForSsl() {
        return this.useAcmCertificateForSsl;
    }

    @Override
    public String getAcmCertificateArn() {
        return this.acmCertificateArn;
    }

    @Override
    public String getAcmPrivateKeyPassword() {
        return this.acmPrivateKeyPassword;
    }

    @Override
    public int getAcmCertificateTimeoutMillis() {
        return this.acmCertificateTimeoutMillis;
    }

    @Override
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Override
    public PluginModel getAuthentication() {
        return this.authentication;
    }

    @Override
    public boolean hasHealthCheckService() {
        return this.healthCheckService;
    }

    @Override
    public boolean isUnauthenticatedHealthCheck() {
        return this.unauthenticatedHealthCheck;
    }

    @Override
    public ByteCount getMaxRequestLength() {
        return this.maxRequestLength;
    }
}

