/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.server;

import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;

public class ServerConfiguration {
    static final int DEFAULT_REQUEST_TIMEOUT_MS = 10000;
    static final boolean DEFAULT_ENABLED_UNFRAMED_REQUESTS = false;
    static final boolean DEFAULT_HEALTH_CHECK = false;
    static final boolean DEFAULT_PROTO_REFLECTION_SERVICE = false;
    static final boolean DEFAULT_SSL = true;
    static final boolean DEFAULT_USE_ACM_CERT_FOR_SSL = false;
    static final int DEFAULT_THREAD_COUNT = 200;
    static final int DEFAULT_MAX_PENDING_REQUESTS = 1024;
    static final int DEFAULT_MAX_CONNECTION_COUNT = 500;
    static final double BUFFER_TIMEOUT_FRACTION = 0.8;
    private String path;
    private boolean healthCheck = false;
    private boolean protoReflectionService = false;
    private int requestTimeoutInMillis = 10000;
    private boolean enableUnframedRequests = false;
    private CompressionOption compression = CompressionOption.NONE;
    private PluginModel authentication;
    private boolean ssl = true;
    private boolean unauthenticatedHealthCheck = false;
    private boolean useAcmCertForSSL = false;
    private ByteCount maxRequestLength;
    private Integer port;
    private RetryInfoConfig retryInfo;
    private int threadCount = 200;
    private int maxConnectionCount = 500;
    private int maxPendingRequests = 1024;
    private int bufferTimeoutInMillis;

    public boolean hasHealthCheck() {
        return this.healthCheck;
    }

    public boolean enableHttpHealthCheck() {
        return this.enableUnframedRequests() && this.hasHealthCheck();
    }

    public boolean hasProtoReflectionService() {
        return this.protoReflectionService;
    }

    public boolean enableUnframedRequests() {
        return this.enableUnframedRequests;
    }

    public boolean useAcmCertForSSL() {
        return this.useAcmCertForSSL;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public void setProtoReflectionService(boolean protoReflectionService) {
        this.protoReflectionService = protoReflectionService;
    }

    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public void setRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
    }

    public void setEnableUnframedRequests(boolean enableUnframedRequests) {
        this.enableUnframedRequests = enableUnframedRequests;
    }

    public void setCompression(CompressionOption compression) {
        this.compression = compression;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }

    public void setAuthentication(PluginModel authentication) {
        this.authentication = authentication;
    }

    public PluginModel getAuthentication() {
        return this.authentication;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setUnauthenticatedHealthCheck(boolean unauthenticatedHealthCheck) {
        this.unauthenticatedHealthCheck = unauthenticatedHealthCheck;
    }

    public boolean isUnauthenticatedHealthCheck() {
        return this.unauthenticatedHealthCheck;
    }

    public boolean isUseAcmCertForSSL() {
        return this.useAcmCertForSSL;
    }

    public void setUseAcmCertForSSL(boolean useAcmCertForSSL) {
        this.useAcmCertForSSL = useAcmCertForSSL;
    }

    public ByteCount getMaxRequestLength() {
        return this.maxRequestLength;
    }

    public void setMaxRequestLength(ByteCount maxRequestLength) {
        this.maxRequestLength = maxRequestLength;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RetryInfoConfig getRetryInfo() {
        return this.retryInfo;
    }

    public void setRetryInfo(RetryInfoConfig retryInfo) {
        this.retryInfo = retryInfo;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public void setMaxConnectionCount(int maxConnectionCount) {
        this.maxConnectionCount = maxConnectionCount;
    }

    public int getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    public void setMaxPendingRequests(int maxPendingRequests) {
        this.maxPendingRequests = maxPendingRequests;
    }

    public int getBufferTimeoutInMillis() {
        return this.bufferTimeoutInMillis;
    }

    public void setBufferTimeoutInMillis(int bufferTimeoutInMillis) {
        this.bufferTimeoutInMillis = bufferTimeoutInMillis;
    }
}

