/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension.api;

import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.geoip.GeoIPDatabase;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;

public interface GeoIPDatabaseReader
extends AutoCloseable {
    public static final String MAXMIND_DATABASE_EXTENSION = ".mmdb";
    public static final Duration MAX_EXPIRY_DURATION = Duration.ofDays(30L);
    public static final String LAT = "lat";
    public static final String LON = "lon";

    public Map<String, Object> getGeoData(InetAddress var1, Collection<GeoIPField> var2, Collection<GeoIPDatabase> var3);

    public boolean isExpired();

    public void retain();

    default public void enrichData(Map<String, Object> geoData, String fieldName, Object fieldValue) {
        if (!geoData.containsKey(fieldName) && fieldValue != null) {
            geoData.put(fieldName, fieldValue);
        }
    }

    default public Optional<String> getDatabaseName(String database, String databasePath, String databaseType) {
        File file = new File(databasePath);
        if (file.exists() && file.isDirectory()) {
            String[] list;
            for (String fileName : list = file.list()) {
                String lowerCaseFileName = fileName.toLowerCase();
                if (!lowerCaseFileName.contains(database.toLowerCase()) || !fileName.endsWith(MAXMIND_DATABASE_EXTENSION) || !lowerCaseFileName.contains(databaseType)) continue;
                return Optional.of(fileName);
            }
        }
        return Optional.empty();
    }

    default public void extractContinentFields(Continent continent, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case CONTINENT_CODE: {
                        this.enrichData(geoData, GeoIPField.CONTINENT_CODE.getFieldName(), continent.getCode());
                        break;
                    }
                    case CONTINENT_NAME: {
                        this.enrichData(geoData, GeoIPField.CONTINENT_NAME.getFieldName(), continent.getName());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.CONTINENT_CODE.getFieldName(), continent.getCode());
            this.enrichData(geoData, GeoIPField.CONTINENT_NAME.getFieldName(), continent.getName());
        }
    }

    default public void extractCountryFields(Country country, Map<String, Object> geoData, Collection<GeoIPField> fields, boolean isEnterpriseDatabase) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case COUNTRY_NAME: {
                        this.enrichData(geoData, GeoIPField.COUNTRY_NAME.getFieldName(), country.getName());
                        break;
                    }
                    case IS_COUNTRY_IN_EUROPEAN_UNION: {
                        this.enrichData(geoData, GeoIPField.IS_COUNTRY_IN_EUROPEAN_UNION.getFieldName(), country.isInEuropeanUnion());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        this.enrichData(geoData, GeoIPField.COUNTRY_ISO_CODE.getFieldName(), country.getIsoCode());
                        break;
                    }
                    case COUNTRY_CONFIDENCE: {
                        if (!isEnterpriseDatabase) break;
                        this.enrichData(geoData, GeoIPField.COUNTRY_CONFIDENCE.getFieldName(), country.getConfidence());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.COUNTRY_NAME.getFieldName(), country.getName());
            this.enrichData(geoData, GeoIPField.IS_COUNTRY_IN_EUROPEAN_UNION.getFieldName(), country.isInEuropeanUnion());
            this.enrichData(geoData, GeoIPField.COUNTRY_ISO_CODE.getFieldName(), country.getIsoCode());
            if (isEnterpriseDatabase) {
                this.enrichData(geoData, GeoIPField.COUNTRY_CONFIDENCE.getFieldName(), country.getConfidence());
            }
        }
    }

    default public void extractRegisteredCountryFields(Country registeredCountry, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case REGISTERED_COUNTRY_NAME: {
                        this.enrichData(geoData, GeoIPField.REGISTERED_COUNTRY_NAME.getFieldName(), registeredCountry.getName());
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        this.enrichData(geoData, GeoIPField.REGISTERED_COUNTRY_ISO_CODE.getFieldName(), registeredCountry.getIsoCode());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.REGISTERED_COUNTRY_NAME.getFieldName(), registeredCountry.getName());
            this.enrichData(geoData, GeoIPField.REGISTERED_COUNTRY_ISO_CODE.getFieldName(), registeredCountry.getIsoCode());
        }
    }

    default public void extractRepresentedCountryFields(RepresentedCountry representedCountry, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case REPRESENTED_COUNTRY_NAME: {
                        this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_NAME.getFieldName(), representedCountry.getName());
                        break;
                    }
                    case REPRESENTED_COUNTRY_ISO_CODE: {
                        this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_ISO_CODE.getFieldName(), representedCountry.getIsoCode());
                        break;
                    }
                    case REPRESENTED_COUNTRY_TYPE: {
                        this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_TYPE.getFieldName(), representedCountry.getType());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_NAME.getFieldName(), representedCountry.getName());
            this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_ISO_CODE.getFieldName(), representedCountry.getIsoCode());
            this.enrichData(geoData, GeoIPField.REPRESENTED_COUNTRY_TYPE.getFieldName(), representedCountry.getType());
        }
    }

    default public void extractCityFields(City city, Map<String, Object> geoData, Collection<GeoIPField> fields, boolean isEnterpriseDatabase) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                if (field.equals((Object)GeoIPField.CITY_NAME)) {
                    this.enrichData(geoData, GeoIPField.CITY_NAME.getFieldName(), city.getName());
                    continue;
                }
                if (!isEnterpriseDatabase || !field.equals((Object)GeoIPField.CITY_CONFIDENCE)) continue;
                this.enrichData(geoData, GeoIPField.CITY_CONFIDENCE.getFieldName(), city.getConfidence());
            }
        } else {
            this.enrichData(geoData, GeoIPField.CITY_NAME.getFieldName(), city.getName());
            if (isEnterpriseDatabase) {
                this.enrichData(geoData, GeoIPField.CITY_CONFIDENCE.getFieldName(), city.getConfidence());
            }
        }
    }

    default public void extractLocationFields(Location location, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        HashMap<String, Double> locationObject = new HashMap<String, Double>();
        locationObject.put(LAT, location.getLatitude());
        locationObject.put(LON, location.getLongitude());
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case LOCATION: {
                        this.enrichData(geoData, GeoIPField.LOCATION.getFieldName(), locationObject);
                        break;
                    }
                    case LATITUDE: {
                        this.enrichData(geoData, GeoIPField.LATITUDE.getFieldName(), location.getLatitude());
                        break;
                    }
                    case LONGITUDE: {
                        this.enrichData(geoData, GeoIPField.LONGITUDE.getFieldName(), location.getLongitude());
                        break;
                    }
                    case METRO_CODE: {
                        this.enrichData(geoData, GeoIPField.METRO_CODE.getFieldName(), location.getMetroCode());
                        break;
                    }
                    case TIME_ZONE: {
                        this.enrichData(geoData, GeoIPField.TIME_ZONE.getFieldName(), location.getTimeZone());
                        break;
                    }
                    case LOCATION_ACCURACY_RADIUS: {
                        this.enrichData(geoData, GeoIPField.LOCATION_ACCURACY_RADIUS.getFieldName(), location.getAccuracyRadius());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.LOCATION.getFieldName(), locationObject);
            this.enrichData(geoData, GeoIPField.METRO_CODE.getFieldName(), location.getMetroCode());
            this.enrichData(geoData, GeoIPField.TIME_ZONE.getFieldName(), location.getTimeZone());
            this.enrichData(geoData, GeoIPField.LOCATION_ACCURACY_RADIUS.getFieldName(), location.getAccuracyRadius());
        }
    }

    default public void extractPostalFields(Postal postal, Map<String, Object> geoData, Collection<GeoIPField> fields, boolean isEnterpriseDatabase) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                if (field.equals((Object)GeoIPField.POSTAL_CODE)) {
                    this.enrichData(geoData, GeoIPField.POSTAL_CODE.getFieldName(), postal.getCode());
                    continue;
                }
                if (!isEnterpriseDatabase || !field.equals((Object)GeoIPField.POSTAL_CODE_CONFIDENCE)) continue;
                this.enrichData(geoData, GeoIPField.POSTAL_CODE_CONFIDENCE.getFieldName(), postal.getConfidence());
            }
        } else {
            this.enrichData(geoData, GeoIPField.POSTAL_CODE.getFieldName(), postal.getCode());
            if (isEnterpriseDatabase) {
                this.enrichData(geoData, GeoIPField.POSTAL_CODE_CONFIDENCE.getFieldName(), postal.getConfidence());
            }
        }
    }

    default public void extractMostSpecifiedSubdivisionFields(Subdivision subdivision, Map<String, Object> geoData, Collection<GeoIPField> fields, boolean isEnterpriseDatabase) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case MOST_SPECIFIED_SUBDIVISION_NAME: {
                        this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_NAME.getFieldName(), subdivision.getName());
                        break;
                    }
                    case MOST_SPECIFIED_SUBDIVISION_ISO_CODE: {
                        this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_ISO_CODE.getFieldName(), subdivision.getIsoCode());
                        break;
                    }
                    case MOST_SPECIFIED_SUBDIVISION_CONFIDENCE: {
                        if (!isEnterpriseDatabase) break;
                        this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_CONFIDENCE.getFieldName(), subdivision.getConfidence());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_NAME.getFieldName(), subdivision.getName());
            this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_ISO_CODE.getFieldName(), subdivision.getIsoCode());
            if (isEnterpriseDatabase) {
                this.enrichData(geoData, GeoIPField.MOST_SPECIFIED_SUBDIVISION_CONFIDENCE.getFieldName(), subdivision.getConfidence());
            }
        }
    }

    default public void extractLeastSpecifiedSubdivisionFields(Subdivision subdivision, Map<String, Object> geoData, Collection<GeoIPField> fields, boolean isEnterpriseDatabase) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case LEAST_SPECIFIED_SUBDIVISION_NAME: {
                        this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_NAME.getFieldName(), subdivision.getName());
                        break;
                    }
                    case LEAST_SPECIFIED_SUBDIVISION_ISO_CODE: {
                        this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_ISO_CODE.getFieldName(), subdivision.getIsoCode());
                        break;
                    }
                    case LEAST_SPECIFIED_SUBDIVISION_CONFIDENCE: {
                        if (!isEnterpriseDatabase) break;
                        this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_CONFIDENCE.getFieldName(), subdivision.getConfidence());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_NAME.getFieldName(), subdivision.getName());
            this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_ISO_CODE.getFieldName(), subdivision.getIsoCode());
            if (isEnterpriseDatabase) {
                this.enrichData(geoData, GeoIPField.LEAST_SPECIFIED_SUBDIVISION_CONFIDENCE.getFieldName(), subdivision.getConfidence());
            }
        }
    }

    default public void extractAsnFields(AsnResponse asnResponse, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        if (!fields.isEmpty()) {
            for (GeoIPField field : fields) {
                switch (field) {
                    case ASN: {
                        this.enrichData(geoData, GeoIPField.ASN.getFieldName(), asnResponse.getAutonomousSystemNumber());
                        break;
                    }
                    case ASN_ORGANIZATION: {
                        this.enrichData(geoData, GeoIPField.ASN_ORGANIZATION.getFieldName(), asnResponse.getAutonomousSystemOrganization());
                        break;
                    }
                    case NETWORK: {
                        this.enrichData(geoData, GeoIPField.NETWORK.getFieldName(), asnResponse.getNetwork().toString());
                        break;
                    }
                    case IP: {
                        this.enrichData(geoData, GeoIPField.IP.getFieldName(), asnResponse.getIpAddress());
                    }
                }
            }
        } else {
            this.enrichData(geoData, GeoIPField.ASN.getFieldName(), asnResponse.getAutonomousSystemNumber());
            this.enrichData(geoData, GeoIPField.ASN_ORGANIZATION.getFieldName(), asnResponse.getAutonomousSystemOrganization());
            this.enrichData(geoData, GeoIPField.NETWORK.getFieldName(), asnResponse.getNetwork().toString());
            this.enrichData(geoData, GeoIPField.IP.getFieldName(), asnResponse.getIpAddress());
        }
    }
}

