/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.plugins.geoip.extension.AwsAuthenticationOptionsConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.DatabaseSourceIdentification;
import org.opensearch.dataprepper.plugins.geoip.extension.MaxMindDatabaseConfig;

public class MaxMindConfig {
    private static final boolean DEFAULT_INSECURE = false;
    private static final String S3_PREFIX = "s3://";
    private static final Duration DEFAULT_DATABASE_REFRESH_INTERVAL = Duration.ofDays(7L);
    private static final int DEFAULT_CACHE_COUNT = 4096;
    @Valid
    @JsonProperty(value="databases")
    private MaxMindDatabaseConfig maxMindDatabaseConfig = new MaxMindDatabaseConfig();
    @JsonProperty(value="database_refresh_interval")
    @DurationMin(minutes=15L)
    @DurationMax(days=30L)
    private @DurationMin(minutes=15L) @DurationMax(days=30L) Duration databaseRefreshInterval = DEFAULT_DATABASE_REFRESH_INTERVAL;
    @JsonProperty(value="cache_count")
    @Min(value=100L)
    @Max(value=100000L)
    private @Min(value=100L) @Max(value=100000L) int cacheSize = 4096;
    @Valid
    @JsonProperty(value="aws")
    private AwsAuthenticationOptionsConfig awsAuthenticationOptionsConfig;
    @JsonProperty(value="insecure")
    private boolean insecure = false;
    @JsonProperty(value="database_destination")
    private String databaseDestination = System.getProperty("data-prepper.dir") + File.separator + "data" + File.separator + "geoip";

    @AssertTrue(message="aws should be configured if any path in database_paths is S3 bucket path.")
    public @AssertTrue(message="aws should be configured if any path in database_paths is S3 bucket path.") boolean isAwsAuthenticationOptionsValid() {
        ArrayList<String> databasePaths = new ArrayList<String>(this.maxMindDatabaseConfig.getDatabasePaths().values());
        for (String databasePath : databasePaths) {
            if (!databasePath.startsWith(S3_PREFIX)) continue;
            return this.awsAuthenticationOptionsConfig != null;
        }
        return true;
    }

    @AssertTrue(message="database_paths should be https endpoint if using URL and if insecure is set to false")
    public @AssertTrue(message="database_paths should be https endpoint if using URL and if insecure is set to false") boolean isHttpsEndpointOrInsecure() throws URISyntaxException {
        if (this.insecure) {
            return true;
        }
        ArrayList<String> databasePaths = new ArrayList<String>(this.maxMindDatabaseConfig.getDatabasePaths().values());
        for (String databasePath : databasePaths) {
            if (!DatabaseSourceIdentification.isURL(databasePath)) continue;
            return new URI(databasePath).getScheme().equals("https");
        }
        return true;
    }

    public MaxMindDatabaseConfig getMaxMindDatabaseConfig() {
        return this.maxMindDatabaseConfig;
    }

    public Duration getDatabaseRefreshInterval() {
        return this.databaseRefreshInterval;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public AwsAuthenticationOptionsConfig getAwsAuthenticationOptionsConfig() {
        return this.awsAuthenticationOptionsConfig;
    }

    public String getDatabaseDestination() {
        return this.databaseDestination;
    }
}

