/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.event_json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.configuration.DataPrepperVersion;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.event_json.EventJsonInputCodecConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="event_json", pluginType=InputCodec.class, pluginConfigurationType=EventJsonInputCodecConfig.class)
public class EventJsonInputCodec
implements InputCodec {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonEvent.class);
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private final JsonFactory jsonFactory = new JsonFactory();
    private final Boolean overrideTimeReceived;

    @DataPrepperPluginConstructor
    public EventJsonInputCodec(EventJsonInputCodecConfig config) {
        this.overrideTimeReceived = config.getOverrideTimeReceived();
    }

    private boolean isCompatibleVersion(Map<String, Object> json) {
        String versionStr = (String)json.get("version");
        DataPrepperVersion version = DataPrepperVersion.parse((String)versionStr);
        DataPrepperVersion currentVersion = DataPrepperVersion.getCurrentVersion();
        return currentVersion.compatibleWith(version);
    }

    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(eventConsumer);
        JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
        while (!jsonParser.isClosed() && jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            Map innerJson = (Map)this.objectMapper.readValue(jsonParser, Map.class);
            if (!this.isCompatibleVersion(innerJson)) {
                return;
            }
            List events = (List)innerJson.get("events");
            for (Map eventMap : events) {
                Record<Event> record = this.createRecord(eventMap);
                if (record == null) continue;
                eventConsumer.accept(record);
            }
        }
    }

    private Record<Event> createRecord(Map<String, Object> innerJson) {
        Map metadata = (Map)innerJson.get("metadata");
        EventMetadata eventMetadata = (EventMetadata)this.objectMapper.convertValue((Object)metadata, DefaultEventMetadata.class);
        Map data = (Map)innerJson.get("data");
        if (data == null) {
            return null;
        }
        if (!this.overrideTimeReceived.booleanValue()) {
            eventMetadata = new DefaultEventMetadata.Builder().withEventType(EventType.LOG.toString()).withAttributes(eventMetadata.getAttributes()).withTimeReceived(Instant.now()).withTags(eventMetadata.getTags()).withExternalOriginationTime(eventMetadata.getExternalOriginationTime()).build();
        }
        JacksonLog.Builder logBuilder = (JacksonLog.Builder)JacksonLog.builder().withData((Object)data).withEventMetadata(eventMetadata).getThis();
        JacksonLog event = logBuilder.build();
        Record record = new Record((Object)event);
        return record;
    }
}

