/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.util.Arrays;
import org.opensearch.dataprepper.model.encryption.EncryptionEnvelope;

public class DefaultEncryptionEnvelope
implements EncryptionEnvelope {
    private byte[] encryptedData;
    private String encryptedDataKey;

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public String getEncryptedDataKey() {
        return this.encryptedDataKey;
    }

    DefaultEncryptionEnvelope(byte[] encryptedData, String encryptedDataKey) {
        this.encryptedData = encryptedData;
        this.encryptedDataKey = encryptedDataKey;
    }

    public static DefaultEncryptionEnvelopeBuilder builder() {
        return new DefaultEncryptionEnvelopeBuilder();
    }

    public static class DefaultEncryptionEnvelopeBuilder {
        private byte[] encryptedData;
        private String encryptedDataKey;

        DefaultEncryptionEnvelopeBuilder() {
        }

        public DefaultEncryptionEnvelopeBuilder encryptedData(byte[] encryptedData) {
            this.encryptedData = encryptedData;
            return this;
        }

        public DefaultEncryptionEnvelopeBuilder encryptedDataKey(String encryptedDataKey) {
            this.encryptedDataKey = encryptedDataKey;
            return this;
        }

        public DefaultEncryptionEnvelope build() {
            return new DefaultEncryptionEnvelope(this.encryptedData, this.encryptedDataKey);
        }

        public String toString() {
            return "DefaultEncryptionEnvelope.DefaultEncryptionEnvelopeBuilder(encryptedData=" + Arrays.toString(this.encryptedData) + ", encryptedDataKey=" + this.encryptedDataKey + ")";
        }
    }
}

