/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.leader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ShardCache {
    private static final String DEFAULT_SHARD_ID_PREFIX = "shardId-";
    private final Map<String, List<String>> cache = new HashMap<String, List<String>>();

    public void put(String shardId, String parentShardId) {
        Objects.requireNonNull(shardId);
        if (parentShardId != null && !parentShardId.isEmpty()) {
            String trimedParentShardId = this.removeShardIdPrefix(parentShardId);
            String trimedShardId = this.removeShardIdPrefix(shardId);
            List childShards = this.cache.getOrDefault(trimedParentShardId, new ArrayList());
            childShards.add(trimedShardId);
            this.cache.put(trimedParentShardId, childShards);
        }
    }

    public List<String> get(String parentShardId) {
        List<String> childShardIds = this.cache.get(this.removeShardIdPrefix(parentShardId));
        if (childShardIds == null) {
            return null;
        }
        return childShardIds.stream().map(this::appendShardIdPrefix).collect(Collectors.toList());
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    private String removeShardIdPrefix(String shardId) {
        return shardId.substring(DEFAULT_SHARD_ID_PREFIX.length());
    }

    private String appendShardIdPrefix(String shardId) {
        return DEFAULT_SHARD_ID_PREFIX + shardId;
    }
}

