/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.utils;

import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.plugins.source.dynamodb.stream.StreamScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamScheduler.class);
    private static final Random RANDOM = new Random();
    static final Duration STARTING_BACKOFF = Duration.ofMillis(500L);
    static final Duration MAX_BACKOFF_WITH_SHARDS = Duration.ofSeconds(15L);
    static final Duration MAX_BACKOFF_NO_SHARDS_ACQUIRED = Duration.ofSeconds(15L);
    static final int BACKOFF_RATE = 2;
    static final Duration MAX_JITTER = Duration.ofSeconds(2L);
    static final Duration MIN_JITTER = Duration.ofSeconds(-2L);
    private final boolean isExportConfigured;

    public BackoffCalculator(boolean isExportConfigured) {
        this.isExportConfigured = isExportConfigured;
    }

    public long calculateBackoffToAcquireNextShard(int noAvailableShardCount, AtomicInteger shardsAcquired) {
        if (noAvailableShardCount > 0) {
            if (noAvailableShardCount % 50 == 0 && shardsAcquired.get() == 0) {
                Object errorMessage = String.format("No new shards acquired after %s attempts. This means that all shards are currently being consumed", noAvailableShardCount);
                if (this.isExportConfigured) {
                    errorMessage = (String)errorMessage + ", or that the export is still in progress. New shards will not be consumed until the export is fully processed.";
                }
                LOG.info((String)errorMessage);
            }
            long jitterMillis = MIN_JITTER.toMillis() + (long)RANDOM.nextInt((int)(MAX_JITTER.toMillis() - MIN_JITTER.toMillis() + 1L));
            return Math.max(1L, Longs.min((long[])new long[]{STARTING_BACKOFF.toMillis() * LongMath.pow((long)2L, (int)((int)Longs.min((long[])new long[]{noAvailableShardCount - 1, 8L}))) + jitterMillis, MAX_BACKOFF_NO_SHARDS_ACQUIRED.toMillis()}));
        }
        return Math.max(500L, Longs.min((long[])new long[]{MAX_BACKOFF_WITH_SHARDS.toMillis(), (long)shardsAcquired.get() * STARTING_BACKOFF.toMillis()}));
    }
}

