/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.drop;

import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.plugins.processor.drop.DropEventProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DropEventsWhenCondition {
    private static final Logger LOG = LoggerFactory.getLogger(DropEventsWhenCondition.class);
    private static final String HARDCODED_TRUE = "true";
    private final String dropWhen;
    private final HandleFailedEventsOption handleFailedEventsSetting;
    private final ExpressionEvaluator expressionEvaluator;
    private final boolean notAlwaysTrue;

    DropEventsWhenCondition(Builder builder) {
        this.dropWhen = builder.dropWhen;
        this.handleFailedEventsSetting = builder.handleFailedEventsSetting;
        this.expressionEvaluator = builder.expressionEvaluator;
        this.notAlwaysTrue = !Objects.equals(this.dropWhen, HARDCODED_TRUE);
    }

    public boolean isNotAlwaysTrue() {
        return this.notAlwaysTrue;
    }

    public boolean isStatementFalseWith(Event event) {
        try {
            return this.expressionEvaluator.evaluateConditional(this.dropWhen, event) == false;
        }
        catch (Exception e) {
            if (this.handleFailedEventsSetting.shouldLog()) {
                LOG.warn(DataPrepperMarkers.EVENT, "An exception occurred while processing when expression for event [{}]", (Object)event, (Object)e);
            }
            return this.handleFailedEventsSetting.shouldDropEvent();
        }
    }

    static class Builder {
        private String dropWhen;
        private HandleFailedEventsOption handleFailedEventsSetting;
        private ExpressionEvaluator expressionEvaluator;

        Builder() {
        }

        public Builder withDropEventsProcessorConfig(DropEventProcessorConfig dropEventProcessorConfig) {
            this.dropWhen = Objects.requireNonNull(dropEventProcessorConfig.getDropWhen());
            this.handleFailedEventsSetting = Objects.requireNonNull(dropEventProcessorConfig.getHandleFailedEventsOption());
            return this;
        }

        public Builder withExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
            this.expressionEvaluator = expressionEvaluator;
            return this;
        }

        public DropEventsWhenCondition build() {
            if (this.dropWhen == null) {
                throw new IllegalArgumentException("Starting in Data Prepper v1.3.0 drop_events processor requires \"when\" option to be specified. See https://github.com/opensearch-project/data-prepper/blob/main/data-prepper-plugins/drop-events-processor/README.md for more information");
            }
            if (!Objects.equals(this.dropWhen, DropEventsWhenCondition.HARDCODED_TRUE) && this.expressionEvaluator == null) {
                throw new IllegalStateException("Use of drop events processor when setting requires a ExpressionEvaluator bean at runtime");
            }
            return new DropEventsWhenCondition(this);
        }
    }
}

