/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.drop;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>drop_events</code> processor conditionally drops events.")
public class DropEventProcessorConfig {
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/log_type == \"DEBUG\"</code>. The <code>drop_when</code> processor will drop all events where the condition evaluates to true. Those events will not go to any further processors or sinks.")
    @JsonProperty(value="drop_when")
    @NotEmpty
    @ExampleValues(value={@ExampleValues.Example(value="/log_type == \"DEBUG\"", description="Drops events if the log type is DEBUG.")})
    private String dropWhen;
    @JsonPropertyDescription(value="Specifies how exceptions are handled when an exception occurs while evaluating an event. Default value is <code>skip</code>, which sends the events to further processors or sinks.")
    @JsonProperty(value="handle_failed_events", defaultValue="skip")
    private HandleFailedEventsOption handleFailedEventsOption = HandleFailedEventsOption.SKIP;

    public String getDropWhen() {
        return this.dropWhen;
    }

    public HandleFailedEventsOption getHandleFailedEventsOption() {
        return this.handleFailedEventsOption;
    }
}

