/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike.rest;

import io.micrometer.core.instrument.Counter;
import java.net.URI;
import java.util.Collections;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.crowdstrike.rest.CrowdStrikeAuthClient;
import org.opensearch.dataprepper.plugins.source.crowdstrike.utils.Constants;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Named
public class CrowdStrikeRestClient {
    static final String AUTH_FAILURES_COUNTER = "authFailures";
    private static final Logger log = LoggerFactory.getLogger(CrowdStrikeRestClient.class);
    private final Counter authFailures;
    private final RestTemplate restTemplate;
    private final CrowdStrikeAuthClient authClient;

    public CrowdStrikeRestClient(PluginMetrics pluginMetrics, CrowdStrikeAuthClient authClient) {
        this.authFailures = pluginMetrics.counter(AUTH_FAILURES_COUNTER);
        this.restTemplate = new RestTemplate();
        this.authClient = authClient;
    }

    public <T> ResponseEntity<T> invokeGetApi(URI uri, Class<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.authClient.getBearerToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        for (int retryCount = 0; retryCount < 6; ++retryCount) {
            try {
                return this.restTemplate.exchange(uri, HttpMethod.GET, requestEntity, responseType);
            }
            catch (HttpClientErrorException ex) {
                HttpStatus statusCode = ex.getStatusCode();
                String statusMessage = ex.getMessage();
                log.error("An exception has occurred while getting response from search API  {}", (Object)ex.getMessage());
                if (statusCode == HttpStatus.FORBIDDEN) {
                    throw new UnauthorizedException(statusMessage);
                }
                if (statusCode == HttpStatus.UNAUTHORIZED) {
                    this.authFailures.increment();
                    log.warn(DataPrepperMarkers.NOISY, "Token expired. We will try to renew the tokens now", (Throwable)ex);
                    this.authClient.refreshToken();
                } else if (statusCode == HttpStatus.TOO_MANY_REQUESTS) {
                    log.error(DataPrepperMarkers.NOISY, "Hitting API rate limit. Backing off with sleep timer.", (Throwable)ex);
                }
                try {
                    Thread.sleep((long)Constants.RETRY_ATTEMPT_SLEEP_TIME.get(retryCount).intValue() * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Sleep in the retry attempt got interrupted", e);
                }
            }
        }
        String errorMessage = String.format("Exceeded max retry attempts. Failed to execute the Rest API call %s", uri);
        log.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }
}

