/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.metricpublisher;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.SdkMetric;

public class MicrometerMetricPublisher
implements MetricPublisher {
    private static Logger LOG = LoggerFactory.getLogger(MicrometerMetricPublisher.class);
    private static final String SERVICE_ID = "ServiceId";
    private static final String OPERATION_NAME = "OperationName";
    private static final Set<SdkMetric<String>> DEFAULT_DIMENSIONS = Set.of(CoreMetric.SERVICE_ID, CoreMetric.OPERATION_NAME);
    private final PluginMetrics pluginMetrics;

    public MicrometerMetricPublisher(PluginMetrics pluginMetrics) {
        this.pluginMetrics = pluginMetrics;
    }

    public void publish(MetricCollection metricCollection) {
        Map<String, String> dimensions = metricCollection.stream().filter(metricRecord -> DEFAULT_DIMENSIONS.contains(metricRecord.metric())).collect(Collectors.toMap(metricRecord -> metricRecord.metric().name(), metricRecord -> metricRecord.value().toString()));
        String serviceIdValue = dimensions.get(SERVICE_ID);
        String operationNameValue = dimensions.get(OPERATION_NAME);
        this.addMetricsToPluginMetrics(metricCollection, serviceIdValue, operationNameValue);
    }

    public void close() {
    }

    private void addMetricsToPluginMetrics(MetricCollection metricCollection, String serviceIdValue, String operationNameValue) {
        metricCollection.children().forEach(child -> this.addMetricsToPluginMetrics((MetricCollection)child, serviceIdValue, operationNameValue));
        metricCollection.forEach(metricRecord -> {
            Class metricValueClass = metricRecord.metric().valueClass();
            String metricName = metricRecord.metric().name();
            if (Duration.class.isAssignableFrom(metricValueClass)) {
                long metricValueInMillis = Duration.parse(metricRecord.value().toString()).toMillis();
                this.pluginMetrics.timerWithTags(metricName, new String[]{SERVICE_ID, serviceIdValue, OPERATION_NAME, operationNameValue}).record(metricValueInMillis, TimeUnit.MILLISECONDS);
            } else if (Number.class.isAssignableFrom(metricValueClass)) {
                Number numberMetricValue = (Number)metricRecord.value();
                this.pluginMetrics.counterWithTags(metricName, new String[]{SERVICE_ID, serviceIdValue, OPERATION_NAME, operationNameValue}).increment(numberMetricValue.doubleValue());
            } else if (Boolean.class.isAssignableFrom(metricValueClass)) {
                Boolean booleanValue = (Boolean)metricRecord.value();
                double metricValue = Boolean.TRUE.equals(booleanValue) ? 1.0 : 0.0;
                this.pluginMetrics.counterWithTags(metricName, new String[]{SERVICE_ID, serviceIdValue, OPERATION_NAME, operationNameValue}).increment(metricValue);
            } else {
                LOG.trace("Ignoring {} metric. Only metrics with value Class Duration, Number, and Boolean are published.", (Object)metricName);
            }
        });
    }
}

