/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.codec.CompressionEngine;
import org.opensearch.dataprepper.model.codec.DecompressionEngine;
import org.opensearch.dataprepper.plugins.codec.GZipCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.GZipDecompressionEngine;
import org.opensearch.dataprepper.plugins.codec.NoneCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.NoneDecompressionEngine;
import org.opensearch.dataprepper.plugins.codec.SnappyCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.SnappyDecompressionEngine;
import org.opensearch.dataprepper.plugins.codec.ZstdCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.ZstdDecompressionEngine;

public enum CompressionOption {
    NONE("none"),
    GZIP("gzip"),
    SNAPPY("snappy"),
    ZSTD("zstd"),
    AUTOMATIC("automatic");

    private static final Map<String, CompressionOption> OPTIONS_MAP;
    private static final Map<String, DecompressionEngine> DECOMPRESSION_ENGINE_MAP;
    private static final Map<String, CompressionEngine> COMPRESSION_ENGINE_MAP;
    private final String option;

    private CompressionOption(String option) {
        this.option = option.toLowerCase();
    }

    public static CompressionOption fromFileName(String fileName) {
        if (fileName.endsWith(".gz")) {
            return GZIP;
        }
        if (fileName.endsWith(".snappy")) {
            return SNAPPY;
        }
        return NONE;
    }

    public CompressionEngine getCompressionEngine() {
        return COMPRESSION_ENGINE_MAP.getOrDefault(this.option, new NoneCompressionEngine());
    }

    public DecompressionEngine getDecompressionEngine() {
        return DECOMPRESSION_ENGINE_MAP.getOrDefault(this.option, new NoneDecompressionEngine());
    }

    @JsonCreator
    public static CompressionOption fromOptionValue(String option) {
        return OPTIONS_MAP.get(option.toLowerCase());
    }

    static {
        OPTIONS_MAP = Arrays.stream(CompressionOption.values()).collect(Collectors.toMap(value -> value.option, value -> value));
        DECOMPRESSION_ENGINE_MAP = Map.of("none", new NoneDecompressionEngine(), "gzip", new GZipDecompressionEngine(), "snappy", new SnappyDecompressionEngine(), "zstd", new ZstdDecompressionEngine());
        COMPRESSION_ENGINE_MAP = Map.of("none", new NoneCompressionEngine(), "gzip", new GZipCompressionEngine(), "snappy", new SnappyCompressionEngine(), "zstd", new ZstdCompressionEngine());
    }
}

