/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.file;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import jakarta.validation.constraints.AssertTrue;
import java.util.Objects;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.source.file.FileFormat;

public class FileSourceConfig {
    static final String ATTRIBUTE_PATH = "path";
    static final String ATTRIBUTE_TYPE = "record_type";
    static final String ATTRIBUTE_FORMAT = "format";
    static final int DEFAULT_TIMEOUT = 5000;
    static final String DEFAULT_TYPE = "string";
    static final String DEFAULT_FORMAT = "plain";
    static final String EVENT_TYPE = "event";
    @JsonProperty(value="path")
    private String filePathToRead;
    @JsonProperty(value="format")
    private String format = "plain";
    @JsonProperty(value="record_type")
    private String recordType = "string";
    @JsonProperty(value="codec")
    private PluginModel codec;

    public String getFilePathToRead() {
        return this.filePathToRead;
    }

    @JsonIgnore
    public FileFormat getFormat() {
        return FileFormat.getByName(this.format);
    }

    public String getRecordType() {
        return this.recordType;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    void validate() {
        Objects.requireNonNull(this.filePathToRead, "File path is required");
        Preconditions.checkArgument((this.recordType.equals(EVENT_TYPE) || this.recordType.equals(DEFAULT_TYPE) ? 1 : 0) != 0, (Object)"Invalid type: must be either [event] or [string]");
        Preconditions.checkArgument((this.format.equals(DEFAULT_FORMAT) || this.format.equals("json") ? 1 : 0) != 0, (Object)"Invalid file format. Options are [json] and [plain]");
    }

    @AssertTrue(message="The file source requires recordType to be event when using a codec.")
    @AssertTrue(message="The file source requires recordType to be event when using a codec.") boolean codeRequiresRecordTypeEvent() {
        return this.codec == null || this.recordType.equals(EVENT_TYPE);
    }
}

