/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.parquet.io.PositionOutputStream;
import org.opensearch.dataprepper.model.io.OutputFile;
import org.opensearch.dataprepper.plugins.fs.LocalFilePositionOutputStream;

public class LocalOutputFile
implements OutputFile {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final File file;

    public LocalOutputFile(File file) {
        this.file = file;
    }

    public PositionOutputStream create(long blockSizeHint) throws IOException {
        try {
            return LocalFilePositionOutputStream.create(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Failed to create file: " + this.file.toString(), e);
        }
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
        return this.create(blockSizeHint);
    }

    public boolean supportsBlockSize() {
        return true;
    }

    public long defaultBlockSize() {
        return 8192L;
    }
}

