/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.certificate.s3;

import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.acm.ACMCertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.file.FileCertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.s3.S3CertificateProvider;
import org.opensearch.dataprepper.plugins.metricpublisher.MicrometerMetricPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.AcmClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class CertificateProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateProviderFactory.class);
    private final boolean useAcmCertForSSL;
    private final Region awsRegion;
    private final String acmCertificateArn;
    private final long acmCertIssueTimeOutMillis;
    private final String acmPrivateKeyPassword;
    private final boolean isSslCertAndKeyFileInS3;
    private final String sslCertificateFile;
    private final String sslKeyFile;

    public CertificateProviderFactory(boolean useAcmCertForSSL, Region awsRegion, String acmCertificateArn, long acmCertIssueTimeOutMillis, String acmPrivateKeyPassword, boolean isSslCertAndKeyFileInS3, String sslCertificateFile, String sslKeyFile) {
        this.useAcmCertForSSL = useAcmCertForSSL;
        this.awsRegion = awsRegion;
        this.acmCertificateArn = acmCertificateArn;
        this.acmCertIssueTimeOutMillis = acmCertIssueTimeOutMillis;
        this.acmPrivateKeyPassword = acmPrivateKeyPassword;
        this.isSslCertAndKeyFileInS3 = isSslCertAndKeyFileInS3;
        this.sslCertificateFile = sslCertificateFile;
        this.sslKeyFile = sslKeyFile;
    }

    public CertificateProvider getCertificateProvider() {
        if (this.useAcmCertForSSL) {
            LOG.info("Using ACM certificate and private key for SSL/TLS.");
            AwsCredentialsProviderChain credentialsProvider = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
            ClientOverrideConfiguration clientConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryMode.STANDARD).build();
            PluginMetrics awsSdkMetrics = PluginMetrics.fromNames((String)"sdk", (String)"aws");
            AcmClient awsCertificateManager = (AcmClient)((AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)((AcmClientBuilder)AcmClient.builder().region(this.awsRegion)).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).overrideConfiguration(clientConfig)).overrideConfiguration(metricPublisher -> metricPublisher.addMetricPublisher((MetricPublisher)new MicrometerMetricPublisher(awsSdkMetrics)))).build();
            return new ACMCertificateProvider(awsCertificateManager, this.acmCertificateArn, this.acmCertIssueTimeOutMillis, this.acmPrivateKeyPassword);
        }
        if (this.isSslCertAndKeyFileInS3) {
            LOG.info("Using S3 to fetch certificate and private key for SSL/TLS.");
            AwsCredentialsProviderChain credentialsProvider = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
            S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.awsRegion)).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build();
            return new S3CertificateProvider(s3Client, this.sslCertificateFile, this.sslKeyFile);
        }
        LOG.info("Using local file system to get certificate and private key for SSL/TLS.");
        return new FileCertificateProvider(this.sslCertificateFile, this.sslKeyFile);
    }
}

