/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.s3keyindex;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class S3ObjectIndexUtility {
    private static final String TIME_PATTERN_STARTING_SYMBOLS = "\\%{";
    private static final String TIME_PATTERN_REGULAR_EXPRESSION = "\\%\\{.*?\\}";
    private static final String TIME_PATTERN_INTERNAL_EXTRACTOR_REGULAR_EXPRESSION = "\\%\\{(.*?)\\}";
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("\\%\\{(.*?)\\}");
    private static final ZoneId UTC_ZONE_ID = ZoneId.of(TimeZone.getTimeZone("UTC").getID());
    private static final Set<Character> INVALID_CHARS = Set.of(Character.valueOf('#'), Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(','), Character.valueOf(':'));
    private static final Set<Character> UNSUPPORTED_TIME_GRANULARITY_CHARS = Set.of(Character.valueOf('A'), Character.valueOf('n'), Character.valueOf('N'));

    S3ObjectIndexUtility() {
    }

    public static String getObjectNameWithDateTimeId(String indexAlias) {
        DateTimeFormatter dateFormatter = S3ObjectIndexUtility.validateAndGetDateTimeFormatter(indexAlias);
        String suffix = dateFormatter != null ? dateFormatter.format(S3ObjectIndexUtility.getCurrentUtcTime()) : "";
        return indexAlias.replaceAll(TIME_PATTERN_REGULAR_EXPRESSION, suffix + "-" + S3ObjectIndexUtility.getTimeNanos() + "-" + String.valueOf(UUID.randomUUID()));
    }

    public static String getObjectPathPrefix(String indexAlias) {
        DateTimeFormatter dateFormatter = S3ObjectIndexUtility.validateAndGetDateTimeFormatter(indexAlias);
        String suffix = dateFormatter != null ? dateFormatter.format(S3ObjectIndexUtility.getCurrentUtcTime()) : "";
        return indexAlias.replaceAll(TIME_PATTERN_REGULAR_EXPRESSION, "") + suffix;
    }

    public static long getTimeNanos() {
        Instant time = Instant.now();
        long NANO_MULTIPLIER = 1000000000L;
        long currentTimeNanos = time.getEpochSecond() * 1000000000L + (long)time.getNano();
        return currentTimeNanos;
    }

    public static DateTimeFormatter validateAndGetDateTimeFormatter(String indexAlias) {
        Matcher timePatternMatcher = DATE_TIME_PATTERN.matcher(indexAlias);
        if (timePatternMatcher.find()) {
            String timePattern = timePatternMatcher.group(1);
            if (timePatternMatcher.find()) {
                throw new IllegalArgumentException("An index only allows one date-time pattern.");
            }
            if (timePattern.contains(TIME_PATTERN_STARTING_SYMBOLS)) {
                throw new IllegalArgumentException("An index doesn't allow nested date-time patterns.");
            }
            S3ObjectIndexUtility.validateTimePatternIsAtTheEnd(indexAlias, timePattern);
            S3ObjectIndexUtility.validateNoSpecialCharsInTimePattern(timePattern);
            S3ObjectIndexUtility.validateTimePatternGranularity(timePattern);
            return DateTimeFormatter.ofPattern(timePattern);
        }
        return null;
    }

    private static void validateTimePatternIsAtTheEnd(String indexAlias, String timePattern) {
        if (!indexAlias.endsWith(timePattern + "}")) {
            throw new IllegalArgumentException("Time pattern can only be a suffix of an index.");
        }
    }

    public static void validateNoSpecialCharsInTimePattern(String timePattern) {
        boolean containsInvalidCharacter = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(character -> INVALID_CHARS.contains(character));
        if (containsInvalidCharacter) {
            throw new IllegalArgumentException("Index time pattern contains one or multiple special characters: " + String.valueOf(INVALID_CHARS));
        }
    }

    public static void validateTimePatternGranularity(String timePattern) {
        boolean containsUnsupportedTimeSymbol = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(character -> UNSUPPORTED_TIME_GRANULARITY_CHARS.contains(character));
        if (containsUnsupportedTimeSymbol) {
            throw new IllegalArgumentException("Index time pattern contains time patterns that are less than one hour: " + String.valueOf(UNSUPPORTED_TIME_GRANULARITY_CHARS));
        }
    }

    public static ZonedDateTime getCurrentUtcTime() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).withZoneSameInstant(UTC_ZONE_ID);
    }
}

