/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws.sqs.common;

import java.util.Map;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class ClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClientFactory.class);

    private ClientFactory() {
    }

    public static SqsClient createSqsClient(Region region, String roleArn, Map<String, String> stsHeader, AwsCredentialsSupplier awsCredentialsSupplier) {
        LOG.info("Creating SQS client");
        return (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().region(region)).credentialsProvider(awsCredentialsSupplier.getProvider(ClientFactory.convertToCredentialOptions(region, roleArn, stsHeader)))).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(builder -> builder.numRetries(Integer.valueOf(5)).build()).build())).build();
    }

    private static AwsCredentialsOptions convertToCredentialOptions(Region region, String roleArn, Map<String, String> stsHeader) {
        return AwsCredentialsOptions.builder().withRegion(region).withStsRoleArn(roleArn).withStsHeaderOverrides(stsHeader).build();
    }
}

