/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws.sqs.common.model;

import java.time.Duration;

public class SqsOptions {
    private final String sqsUrl;
    private final Integer maximumMessages;
    private final Duration pollDelay;
    private final Duration visibilityTimeout;
    private final Duration waitTime;

    public SqsOptions(Builder builder) {
        this.sqsUrl = builder.sqsUrl;
        this.maximumMessages = builder.maximumMessages;
        this.pollDelay = builder.pollDelay;
        this.visibilityTimeout = builder.visibilityTimeout;
        this.waitTime = builder.waitTime;
    }

    public String getSqsUrl() {
        return this.sqsUrl;
    }

    public Integer getMaximumMessages() {
        return this.maximumMessages;
    }

    public Duration getPollDelay() {
        return this.pollDelay;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public static class Builder {
        private String sqsUrl;
        private Duration visibilityTimeout;
        private Duration waitTime;
        private Integer maximumMessages;
        private Duration pollDelay;

        public Builder setSqsUrl(String sqsUrl) {
            this.sqsUrl = sqsUrl;
            return this;
        }

        public Builder setMaximumMessages(Integer maximumMessages) {
            this.maximumMessages = maximumMessages;
            return this;
        }

        public Builder setPollDelay(Duration pollDelay) {
            this.pollDelay = pollDelay;
            return this;
        }

        public Builder setVisibilityTimeout(Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public Builder setWaitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public SqsOptions build() {
            return new SqsOptions(this);
        }
    }
}

