/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import software.amazon.awssdk.regions.Region;

class CredentialsIdentifier {
    private final String stsRoleArn;
    private final Region region;
    private final Map<String, String> stsHeaderOverrides;

    private CredentialsIdentifier(String stsRoleArn, Region region, Map<String, String> stsHeaderOverrides) {
        this.stsRoleArn = stsRoleArn;
        this.region = region;
        this.stsHeaderOverrides = stsHeaderOverrides;
    }

    static CredentialsIdentifier fromAwsCredentialsOption(AwsCredentialsOptions options) {
        return new CredentialsIdentifier(options.getStsRoleArn(), options.getRegion(), options.getStsHeaderOverrides());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialsIdentifier that = (CredentialsIdentifier)o;
        return Objects.equals(this.stsRoleArn, that.stsRoleArn) && Objects.equals(this.region, that.region) && Objects.equals(this.stsHeaderOverrides, that.stsHeaderOverrides);
    }

    public int hashCode() {
        return Objects.hash(this.stsRoleArn, this.region, this.stsHeaderOverrides);
    }
}

