/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum InvocationType {
    REQUEST_RESPONSE("request-response", "RequestResponse"),
    EVENT("event", "Event");

    private final String userInputValue;
    private final String awsLambdaValue;
    private static final Map<String, InvocationType> INVOCATION_TYPE_MAP;

    private InvocationType(String userInputValue, String awsLambdaValue) {
        this.userInputValue = userInputValue;
        this.awsLambdaValue = awsLambdaValue;
    }

    @JsonValue
    public String getUserInputValue() {
        return this.userInputValue;
    }

    public String getAwsLambdaValue() {
        return this.awsLambdaValue;
    }

    @JsonCreator
    public static InvocationType fromString(String value) {
        return INVOCATION_TYPE_MAP.get(value);
    }

    static {
        INVOCATION_TYPE_MAP = new HashMap<String, InvocationType>();
        for (InvocationType type : InvocationType.values()) {
            INVOCATION_TYPE_MAP.put(type.getUserInputValue(), type);
        }
    }
}

