/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.processor;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.event.Event;

public class LambdaCacheKey {
    private final List<Object> keys;

    public LambdaCacheKey(List<Object> keys) {
        for (Object key : keys) {
            if (key instanceof String || key instanceof Long || key instanceof Integer) continue;
            throw new RuntimeException("Only String and Long/Integer values are supported in cache");
        }
        this.keys = keys;
    }

    public LambdaCacheKey(Event event, List<String> keyNames) {
        this.keys = new ArrayList<Object>();
        for (String keyName : keyNames) {
            Object value = event.get(keyName, Object.class);
            if (!(value instanceof String || value instanceof Long || value instanceof Integer)) {
                throw new RuntimeException("Only String and Long/Integer values are supported in cache");
            }
            this.keys.add(value);
        }
    }

    public int length() {
        return this.keys.stream().mapToInt(key -> {
            if (key instanceof String) {
                return ((String)key).length();
            }
            return 8;
        }).sum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LambdaCacheKey)) {
            return false;
        }
        return this.keys.equals(((LambdaCacheKey)o).keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }
}

