/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.avro;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.opensearch.dataprepper.avro.AvroEventConverter;
import org.opensearch.dataprepper.avro.SchemaChooser;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;

abstract class AbstractAvroEventConverterTemplate
implements AvroEventConverter {
    private final SchemaChooser schemaChooser;

    protected AbstractAvroEventConverterTemplate(SchemaChooser schemaChooser) {
        this.schemaChooser = schemaChooser;
    }

    @Override
    public GenericRecord convertEventDataToAvro(Schema schema, Map<String, Object> eventData, OutputCodecContext codecContext) {
        return this.convertEventDataToAvro(schema, eventData, codecContext, true);
    }

    private GenericRecord convertEventDataToAvro(Schema schema, Map<String, Object> eventData, OutputCodecContext codecContext, boolean rootOfData) {
        GenericData.Record avroRecord = new GenericData.Record(schema);
        for (String key : this.getKeyNames(schema, eventData, codecContext, rootOfData)) {
            Schema.Field field = schema.getField(key);
            if (field == null) {
                throw new RuntimeException("The event has a key ('" + key + "') which is not included in the schema.");
            }
            Object value = this.schemaMapper(field, eventData.get(key), codecContext);
            avroRecord.put(key, value);
        }
        return avroRecord;
    }

    private Object schemaMapper(Schema.Field field, Object rawValue, OutputCodecContext codecContext) {
        Schema providedSchema = this.schemaChooser.chooseSchema(field.schema());
        if (providedSchema.getType() == Schema.Type.RECORD && rawValue instanceof Map) {
            return this.convertEventDataToAvro(providedSchema, (Map)rawValue, codecContext, false);
        }
        if (providedSchema.getType() == Schema.Type.ARRAY && rawValue instanceof List) {
            GenericData.Array avroArray = new GenericData.Array(((List)rawValue).size(), providedSchema);
            for (Object element : (List)rawValue) {
                avroArray.add(element);
            }
            return avroArray;
        }
        return rawValue;
    }

    abstract Iterable<String> getKeyNames(Schema var1, Map<String, Object> var2, OutputCodecContext var3, boolean var4);
}

