/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.atlassian.configuration.AuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;

public abstract class AtlassianSourceConfig
implements CrawlerSourceConfig {
    @JsonProperty(value="hosts")
    protected List<String> hosts;
    @JsonProperty(value="authentication")
    @Valid
    protected AuthenticationConfig authenticationConfig;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;

    public String getAccountUrl() {
        return this.getHosts().get(0);
    }

    public String getAuthType() {
        return this.getAuthenticationConfig().getAuthType();
    }

    public abstract String getOauth2UrlContext();

    public int getNumberOfWorkers() {
        return 1;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public boolean isAcknowledgments() {
        return this.acknowledgments;
    }
}

