/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.rest.auth;

import org.opensearch.dataprepper.plugins.source.atlassian.AtlassianSourceConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianBasicAuthConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianOauthConfig;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AtlassianAuthFactory
implements FactoryBean<AtlassianAuthConfig> {
    private final AtlassianSourceConfig sourceConfig;

    public AtlassianAuthFactory(AtlassianSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public AtlassianAuthConfig getObject() {
        String authType = this.sourceConfig.getAuthType();
        if ("OAuth2".equals(authType)) {
            return new AtlassianOauthConfig(this.sourceConfig);
        }
        return new AtlassianBasicAuthConfig(this.sourceConfig);
    }

    public Class<?> getObjectType() {
        return AtlassianAuthConfig.class;
    }
}

