/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.rest;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.BadRequestException;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.UnauthorizedException;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.AddressValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AtlassianRestClient {
    private static final Logger log = LoggerFactory.getLogger(AtlassianRestClient.class);
    public static final List<Integer> RETRY_ATTEMPT_SLEEP_TIME = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(40));
    static final String AUTH_FAILURES_COUNTER = "authFailures";
    private int sleepTimeMultiplier = 1000;
    final Counter authFailures;
    private final RestTemplate restTemplate;
    private final AtlassianAuthConfig authConfig;

    public AtlassianRestClient(RestTemplate restTemplate, AtlassianAuthConfig authConfig, PluginMetrics pluginMetrics) {
        this.restTemplate = restTemplate;
        this.authConfig = authConfig;
        this.authFailures = pluginMetrics.counter(AUTH_FAILURES_COUNTER);
    }

    protected <T> ResponseEntity<T> invokeRestApi(URI uri, Class<T> responseType) throws BadRequestException {
        AddressValidation.validateInetAddress((InetAddress)AddressValidation.getInetAddress((String)uri.toString()));
        for (int retryCount = 0; retryCount < 6; ++retryCount) {
            try {
                return this.restTemplate.getForEntity(uri, responseType);
            }
            catch (HttpClientErrorException ex) {
                HttpStatus statusCode = ex.getStatusCode();
                String statusMessage = ex.getMessage();
                log.error(DataPrepperMarkers.NOISY, "HTTP client error while getting response from search API. Status: {}", (Object)statusCode, (Object)ex);
                if (statusCode == HttpStatus.FORBIDDEN) {
                    throw new UnauthorizedException(statusMessage);
                }
                if (statusCode == HttpStatus.UNAUTHORIZED) {
                    this.authFailures.increment();
                    log.error(DataPrepperMarkers.NOISY, "Token expired. We will try to renew the tokens now", (Throwable)ex);
                    this.authConfig.renewCredentials();
                } else if (statusCode == HttpStatus.TOO_MANY_REQUESTS) {
                    log.error(DataPrepperMarkers.NOISY, "Hitting API rate limit. Backing off with sleep timer.", (Throwable)ex);
                }
                try {
                    Thread.sleep((long)RETRY_ATTEMPT_SLEEP_TIME.get(retryCount).intValue() * (long)this.sleepTimeMultiplier);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Sleep in the retry attempt got interrupted", e);
                }
            }
            catch (RestClientException ex) {
                log.error(DataPrepperMarkers.NOISY, "REST client error while getting response from search API: ", (Throwable)ex);
                try {
                    Thread.sleep((long)RETRY_ATTEMPT_SLEEP_TIME.get(retryCount).intValue() * (long)this.sleepTimeMultiplier);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Sleep in the retry attempt got interrupted", e);
                }
            }
        }
        String errorMessage = String.format("Exceeded max retry attempts. Failed to execute the Rest API call %s", uri);
        log.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    @VisibleForTesting
    public void setSleepTimeMultiplier(int multiplier) {
        this.sleepTimeMultiplier = multiplier;
    }
}

