/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.rest;

import org.opensearch.dataprepper.plugins.source.atlassian.AtlassianSourceConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.BasicAuthInterceptor;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.OAuth2RequestInterceptor;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class CustomRestTemplateConfig {
    @Bean
    public RestTemplate basicAuthRestTemplate(AtlassianSourceConfig config, AtlassianAuthConfig authConfig) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        Object httpInterceptor = "OAuth2".equals(config.getAuthType()) ? new OAuth2RequestInterceptor(authConfig) : new BasicAuthInterceptor(config);
        restTemplate.getInterceptors().add(httpInterceptor);
        return restTemplate;
    }
}

