/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.opensearch.dataprepper.plugins.source.atlassian.AtlassianSourceConfig;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class BasicAuthInterceptor
implements ClientHttpRequestInterceptor {
    private final String username;
    private final String password;

    public BasicAuthInterceptor(AtlassianSourceConfig config) {
        this.username = config.getAuthenticationConfig().getBasicConfig().getUsername();
        this.password = config.getAuthenticationConfig().getBasicConfig().getPassword();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String auth = this.username + ":" + this.password;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuth);
        request.getHeaders().set("Authorization", authHeader);
        return execution.execute(request, body);
    }
}

