/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;

@DataPrepperPlugin(name="remove_duplicates", pluginType=AggregateAction.class, pluginConfigurationType=RemoveDuplicatesAggregateActionConfig.class)
public class RemoveDuplicatesAggregateAction
implements AggregateAction {
    static final String GROUP_STATE_HAS_EVENT = "GROUP_STATE_HAS_EVENT";

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        if (groupState.size() == 0) {
            groupState.put(GROUP_STATE_HAS_EVENT, true);
            return AggregateActionResponse.fromEvent(event);
        }
        return AggregateActionResponse.nullEventResponse();
    }

    @JsonPropertyOrder
    @JsonClassDescription(value="The <code>remove_duplicates</code> action processes the first event for a group immediately and drops any events that duplicate the first event from the source.")
    static class RemoveDuplicatesAggregateActionConfig {
        RemoveDuplicatesAggregateActionConfig() {
        }
    }
}

