/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>tail_sampler</code> action samples OpenTelemetry traces after collecting spans for a trace.")
public class TailSamplerAggregateActionConfig {
    @JsonPropertyDescription(value="Period to wait before considering that a trace event is complete")
    @JsonProperty(value="wait_period")
    @NotNull
    private Duration waitPeriod;
    @JsonPropertyDescription(value="Percent value to use for sampling non error events. Must be greater than 0.0 and less than 100.0")
    @JsonProperty(value="percent")
    @NotNull
    private Integer percent;
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as '/some-key == \"test\"', that will be evaluated to determine whether the event is an error event or not")
    @JsonProperty(value="condition")
    private String condition;

    @AssertTrue(message="Percent value must be greater than 0.0 and less than 100.0")
    @AssertTrue(message="Percent value must be greater than 0.0 and less than 100.0") boolean isPercentValid() {
        return (double)this.percent.intValue() > 0.0 && (double)this.percent.intValue() < 100.0;
    }

    public Integer getPercent() {
        return this.percent;
    }

    @AssertTrue(message="Wait period value must be greater than 0 and less than 60")
    @AssertTrue(message="Wait period value must be greater than 0 and less than 60") boolean isWaitPeriodValid() {
        return this.waitPeriod.getSeconds() > 0L && this.waitPeriod.getSeconds() <= 60L;
    }

    public Duration getWaitPeriod() {
        return this.waitPeriod;
    }

    public String getCondition() {
        return this.condition;
    }
}

