/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;

@DataPrepperPlugin(name="put_all", pluginType=AggregateAction.class, pluginConfigurationType=PutAllAggregateActionConfig.class)
public class PutAllAggregateAction
implements AggregateAction {
    static final String EVENT_TYPE = "event";

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        groupState.putAll(event.toMap());
        return AggregateActionResponse.nullEventResponse();
    }

    @Override
    public AggregateActionOutput concludeGroup(AggregateActionInput aggregateActionInput) {
        JacksonEvent event = JacksonEvent.builder().withEventType(EVENT_TYPE).withData((Object)aggregateActionInput.getGroupState()).withEventHandle(aggregateActionInput.getEventHandle()).build();
        return new AggregateActionOutput(List.of(event));
    }

    @JsonPropertyOrder
    @JsonClassDescription(value="The <code>put_all</code> action combines events belonging to the same group by overwriting existing keys and adding new keys, similarly to the Java `Map.putAll`. The action drops all events that make up the combined event.")
    static class PutAllAggregateActionConfig {
        PutAllAggregateActionConfig() {
        }
    }
}

