/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.DefaultEventHandle;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.exceptions.EventKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonEvent
implements Event {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonEvent.class);
    private static final String SEPARATOR = "/";
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module());
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final EventMetadata eventMetadata;
    private transient EventHandle eventHandle;
    private final JsonNode jsonNode;
    static final int MAX_KEY_LENGTH = 2048;
    static final String MESSAGE_KEY = "message";
    static final String EVENT_TYPE = "event";

    protected JacksonEvent(Builder builder) {
        this.eventMetadata = builder.eventMetadata == null ? new DefaultEventMetadata.Builder().withEventType(builder.eventType).withTimeReceived(builder.timeReceived).withAttributes(builder.eventMetadataAttributes).build() : builder.eventMetadata;
        this.jsonNode = this.getInitialJsonNode(builder.data);
        this.eventHandle = new DefaultEventHandle(this.eventMetadata.getTimeReceived());
        Instant externalOriginationTime = this.eventMetadata.getExternalOriginationTime();
        if (externalOriginationTime != null) {
            this.eventHandle.setExternalOriginationTime(externalOriginationTime);
        }
    }

    protected JacksonEvent(JacksonEvent otherEvent) {
        this.jsonNode = otherEvent.jsonNode.deepCopy();
        this.eventMetadata = DefaultEventMetadata.fromEventMetadata(otherEvent.eventMetadata);
        this.eventHandle = new DefaultEventHandle(this.eventMetadata.getTimeReceived());
    }

    public static Event fromMessage(String message) {
        return JacksonEvent.builder().withEventType(EVENT_TYPE).withData(Collections.singletonMap(MESSAGE_KEY, message)).build();
    }

    private JsonNode getInitialJsonNode(Object data) {
        if (data == null) {
            return mapper.valueToTree(new HashMap());
        }
        if (data instanceof String) {
            try {
                return mapper.readTree((String)data);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to convert data into an event");
            }
        }
        return mapper.valueToTree(data);
    }

    @Override
    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    @Override
    public void put(String key, Object value) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"key cannot be an empty string for put method");
        String trimmedKey = this.checkAndTrimKey(key);
        LinkedList<String> keys = new LinkedList<String>(Arrays.asList(trimmedKey.split(SEPARATOR, -1)));
        JsonNode parentNode = this.jsonNode;
        while (!keys.isEmpty()) {
            if (keys.size() == 1) {
                this.setNode(parentNode, keys.removeFirst(), value);
                continue;
            }
            String childKey = keys.removeFirst();
            if (childKey.isEmpty()) continue;
            parentNode = this.getOrCreateNode(parentNode, childKey);
        }
    }

    @Override
    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    private void setNode(JsonNode parentNode, String leafKey, Object value) {
        JsonNode valueNode = mapper.valueToTree(value);
        if (StringUtils.isNumeric((CharSequence)leafKey)) {
            ((ArrayNode)parentNode).set(Integer.parseInt(leafKey), valueNode);
        } else {
            ((ObjectNode)parentNode).set(leafKey, valueNode);
        }
    }

    private JsonNode getOrCreateNode(JsonNode node, String key) {
        JsonNode childNode = node.get(key);
        if (childNode == null) {
            childNode = mapper.createObjectNode();
            ((ObjectNode)node).set(key, childNode);
        }
        return childNode;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return this.mapNodeToObject(key, node, clazz);
    }

    private JsonNode getNode(String key) {
        JsonPointer jsonPointer = this.toJsonPointer(key);
        return this.jsonNode.at(jsonPointer);
    }

    private <T> T mapNodeToObject(String key, JsonNode node, Class<T> clazz) {
        try {
            return (T)mapper.treeToValue((TreeNode)node, clazz);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to map {} to {}", new Object[]{key, clazz, e});
            throw new RuntimeException(String.format("Unable to map %s to %s", key, clazz), e);
        }
    }

    @Override
    public <T> List<T> getList(String key, Class<T> clazz) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return this.mapNodeToList(key, node, clazz);
    }

    private <T> List<T> mapNodeToList(String key, JsonNode node, Class<T> clazz) {
        try {
            ObjectReader reader = mapper.readerFor((JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, clazz));
            return (List)reader.readValue(node);
        }
        catch (IOException e) {
            LOG.error("Unable to map {} to List of {}", new Object[]{key, clazz, e});
            throw new RuntimeException(String.format("Unable to map %s to %s", key, clazz), e);
        }
    }

    private JsonPointer toJsonPointer(String key) {
        Object jsonPointerExpression = key.isEmpty() || key.startsWith(SEPARATOR) ? key : SEPARATOR + key;
        return JsonPointer.compile((String)jsonPointerExpression);
    }

    @Override
    public void delete(String key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"key cannot be an empty string for delete method");
        String trimmedKey = this.checkAndTrimKey(key);
        int index = trimmedKey.lastIndexOf(SEPARATOR);
        JsonNode baseNode = this.jsonNode;
        String leafKey = trimmedKey;
        if (index != -1) {
            JsonPointer jsonPointer = this.toJsonPointer(trimmedKey.substring(0, index));
            baseNode = this.jsonNode.at(jsonPointer);
            leafKey = trimmedKey.substring(index + 1);
        }
        if (!baseNode.isMissingNode()) {
            ((ObjectNode)baseNode).remove(leafKey);
        }
    }

    @Override
    public void clear() {
        Iterator<String> iter = this.toMap().keySet().iterator();
        JsonNode baseNode = this.jsonNode;
        while (iter.hasNext()) {
            ((ObjectNode)baseNode).remove(iter.next());
        }
    }

    @Override
    public String toJsonString() {
        return this.jsonNode.toString();
    }

    @Override
    public String getAsJsonString(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return node.toString();
    }

    @Override
    public String formatString(String format) {
        return this.formatStringInternal(format, null, null);
    }

    @Override
    public String formatString(String format, ExpressionEvaluator expressionEvaluator) {
        return this.formatStringInternal(format, expressionEvaluator, null);
    }

    @Override
    public String formatString(String format, ExpressionEvaluator expressionEvaluator, String defaultValue) {
        return this.formatStringInternal(format, expressionEvaluator, defaultValue);
    }

    private String formatStringInternal(String format, ExpressionEvaluator expressionEvaluator, String defaultValue) {
        int fromIndex = 0;
        Object result = "";
        int position = 0;
        while ((position = format.indexOf("${", fromIndex)) != -1) {
            int endPosition = format.indexOf("}", position + 1);
            if (endPosition == -1) {
                throw new RuntimeException("Format string is not properly formed");
            }
            result = (String)result + format.substring(fromIndex, position);
            String name = format.substring(position + 2, endPosition);
            Object val = null;
            try {
                val = this.get(name, Object.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (val == null) {
                if (expressionEvaluator != null && expressionEvaluator.isValidExpressionStatement(name).booleanValue()) {
                    val = expressionEvaluator.evaluate(name, this);
                } else {
                    if (defaultValue == null) {
                        throw new EventKeyNotFoundException(String.format("The key %s could not be found in the Event when formatting", name));
                    }
                    val = defaultValue;
                }
            }
            if (Objects.nonNull(val)) {
                result = (String)result + val.toString();
            }
            fromIndex = endPosition + 1;
        }
        if (fromIndex < format.length()) {
            result = (String)result + format.substring(fromIndex);
        }
        return result;
    }

    @Override
    public EventMetadata getMetadata() {
        return this.eventMetadata;
    }

    @Override
    public boolean containsKey(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        return !node.isMissingNode();
    }

    @Override
    public boolean isValueAList(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        return node.isArray();
    }

    @Override
    public Map<String, Object> toMap() {
        return (Map)mapper.convertValue((Object)this.jsonNode, MAP_TYPE_REFERENCE);
    }

    public static boolean isValidEventKey(String key) {
        try {
            JacksonEvent.checkKey(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String checkAndTrimKey(String key) {
        JacksonEvent.checkKey(key);
        return this.trimTrailingSlashInKey(key);
    }

    private static void checkKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        if (key.isEmpty()) {
            return;
        }
        if (key.length() > 2048) {
            throw new IllegalArgumentException("key cannot be longer than 2048 characters");
        }
        if (!JacksonEvent.isValidKey(key)) {
            throw new IllegalArgumentException("key " + key + " must contain only alphanumeric chars with .-_@/ and must follow JsonPointer (ie. 'field/to/key')");
        }
    }

    private String trimKey(String key) {
        String trimmedLeadingSlash = key.startsWith(SEPARATOR) ? key.substring(1) : key;
        return this.trimTrailingSlashInKey(trimmedLeadingSlash);
    }

    private String trimTrailingSlashInKey(String key) {
        return key.length() > 1 && key.endsWith(SEPARATOR) ? key.substring(0, key.length() - 1) : key;
    }

    private static boolean isValidKey(String key) {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '-' || c == '_' || c == '@' || c == '/' || c == '[' || c == ']') continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder(){

            public Builder getThis() {
                return this;
            }
        };
    }

    @Override
    public JsonStringBuilder jsonBuilder() {
        return new JsonStringBuilder(this);
    }

    public static JacksonEvent fromEvent(Event event) {
        if (event instanceof JacksonEvent) {
            return new JacksonEvent((JacksonEvent)event);
        }
        return JacksonEvent.builder().withData(event.toMap()).withEventMetadata(event.getMetadata()).build();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.eventHandle = new DefaultEventHandle(this.eventMetadata.getTimeReceived());
    }

    public class JsonStringBuilder
    extends Event.JsonStringBuilder {
        private final boolean RETAIN_ALL = true;
        private final boolean EXCLUDE_ALL = false;
        private final JacksonEvent event;

        private JsonStringBuilder(JacksonEvent event) {
            Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
            this.event = event;
        }

        private JsonNode getBaseNode() {
            if (this.getRootKey() != null && !this.getRootKey().isEmpty() && this.event.containsKey(this.getRootKey())) {
                return this.event.getNode(this.getRootKey());
            }
            return this.event.getJsonNode();
        }

        @Override
        public String toJsonString() {
            String jsonString = this.getIncludeKeys() != null && !this.getIncludeKeys().isEmpty() ? this.searchAndFilter(this.getBaseNode(), "", this.getIncludeKeys(), true) : (this.getExcludeKeys() != null && !this.getExcludeKeys().isEmpty() ? this.searchAndFilter(this.getBaseNode(), "", this.getExcludeKeys(), false) : (this.getBaseNode() != this.event.getJsonNode() ? this.event.getAsJsonString(this.getRootKey()) : this.event.toJsonString()));
            String tagsKey = this.getTagsKey();
            if (tagsKey != null) {
                JsonNode tagsNode = mapper.valueToTree(this.event.getMetadata().getTags());
                return jsonString.substring(0, jsonString.length() - 1) + ",\"" + tagsKey + "\":" + tagsNode.toString() + "}";
            }
            return jsonString;
        }

        String searchAndFilter(JsonNode node, String path, List<String> filterKeys, boolean filterAction) {
            if (node.isArray()) {
                StringJoiner sj = new StringJoiner(",", "[", "]");
                node.forEach(childNode -> sj.add(this.searchAndFilter((JsonNode)childNode, path, filterKeys, filterAction)));
                return sj.toString();
            }
            StringJoiner sj = new StringJoiner(",", "{", "}");
            ArrayList valueList = new ArrayList();
            node.properties().forEach(entry -> {
                String keyPath = JacksonEvent.this.trimKey(path + JacksonEvent.SEPARATOR + (String)entry.getKey());
                boolean found = false;
                for (String key : filterKeys) {
                    if (keyPath.equals(key = JacksonEvent.this.trimKey(key))) {
                        found = true;
                        if (!filterAction) break;
                        valueList.add("\"" + (String)entry.getKey() + "\":" + ((JsonNode)entry.getValue()).toString());
                        break;
                    }
                    if (key.startsWith(keyPath)) {
                        found = true;
                        valueList.add("\"" + (String)entry.getKey() + "\":" + this.searchAndFilter((JsonNode)entry.getValue(), keyPath, filterKeys, filterAction));
                        break;
                    }
                    if (key.compareTo(keyPath) <= 0) continue;
                    break;
                }
                if (!found && !filterAction) {
                    valueList.add("\"" + (String)entry.getKey() + "\":" + ((JsonNode)entry.getValue()).toString());
                }
            });
            valueList.forEach(value -> sj.add((CharSequence)value));
            return sj.toString();
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private EventMetadata eventMetadata;
        private Object data;
        private String eventType;
        private Instant timeReceived;
        private Map<String, Object> eventMetadataAttributes;

        public abstract T getThis();

        public Builder<T> withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder<T> withEventMetadataAttributes(Map<String, Object> eventMetadataAttributes) {
            this.eventMetadataAttributes = eventMetadataAttributes;
            return this;
        }

        public Builder<T> withTimeReceived(Instant timeReceived) {
            this.timeReceived = timeReceived;
            return this;
        }

        public Builder<T> withEventMetadata(EventMetadata eventMetadata) {
            this.eventMetadata = eventMetadata;
            return this;
        }

        public Builder<T> withData(Object data) {
            this.data = data;
            return this;
        }

        public JacksonEvent build() {
            return new JacksonEvent(this);
        }
    }
}

