/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;

public interface OutputCodec {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public void start(OutputStream var1, Event var2, OutputCodecContext var3) throws IOException;

    public void writeEvent(Event var1, OutputStream var2) throws IOException;

    public void complete(OutputStream var1) throws IOException;

    public String getExtension();

    default public boolean isCompressionInternal() {
        return false;
    }

    default public void validateAgainstCodecContext(OutputCodecContext outputCodecContext) {
    }

    default public Event addTagsToEvent(Event event, String tagsTargetKey) throws JsonProcessingException {
        String eventJsonString = event.jsonBuilder().includeTags(tagsTargetKey).toJsonString();
        Map eventData = (Map)objectMapper.readValue(eventJsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return JacksonLog.builder().withData(eventData).build();
    }
}

