/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import io.micrometer.core.instrument.DistributionSummary;
import java.time.Duration;
import java.time.Instant;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.EventHandle;

public class SinkLatencyMetrics {
    public static final String INTERNAL_LATENCY = "PipelineLatency";
    public static final String EXTERNAL_LATENCY = "EndToEndLatency";
    private final DistributionSummary internalLatencySummary;
    private final DistributionSummary externalLatencySummary;

    public SinkLatencyMetrics(PluginMetrics pluginMetrics) {
        this.internalLatencySummary = pluginMetrics.summary(INTERNAL_LATENCY);
        this.externalLatencySummary = pluginMetrics.summary(EXTERNAL_LATENCY);
    }

    public void update(EventHandle eventHandle) {
        Instant now = Instant.now();
        this.internalLatencySummary.record((double)Duration.between(eventHandle.getInternalOriginationTime(), now).toMillis());
        if (eventHandle.getExternalOriginationTime() == null) {
            return;
        }
        this.externalLatencySummary.record((double)Duration.between(eventHandle.getExternalOriginationTime(), now).toMillis());
    }
}

