/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.configuration.DataPrepperVersion;
import org.opensearch.dataprepper.model.configuration.PipelineModel;

public class PipelinesDataFlowModel {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DataPrepperVersion version;
    @JsonAnySetter
    private Map<String, PipelineModel> pipelines = new HashMap<String, PipelineModel>();

    @JsonCreator
    private PipelinesDataFlowModel() {
    }

    public PipelinesDataFlowModel(Map<String, PipelineModel> pipelines) {
        this.pipelines = pipelines;
    }

    public PipelinesDataFlowModel(DataPrepperVersion version, Map<String, PipelineModel> pipelines) {
        this.version = version;
        this.pipelines = pipelines;
    }

    @JsonAnyGetter
    public Map<String, PipelineModel> getPipelines() {
        return this.pipelines;
    }

    @JsonGetter
    public String getVersion() {
        return Objects.isNull(this.version) ? null : this.version.toString();
    }

    @JsonIgnore
    public DataPrepperVersion getDataPrepperVersion() {
        return this.version;
    }

    @JsonSetter
    public void setVersion(String version) {
        this.version = DataPrepperVersion.parse(version);
    }
}

