/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.exceptions.EventKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonEvent
implements Event {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonEvent.class);
    private static final String SEPARATOR = "/";
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module());
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final EventMetadata eventMetadata;
    private EventHandle eventHandle;
    private final JsonNode jsonNode;
    static final int MAX_KEY_LENGTH = 2048;
    static final String MESSAGE_KEY = "message";
    static final String EVENT_TYPE = "event";

    protected JacksonEvent(Builder builder) {
        this.eventMetadata = builder.eventMetadata == null ? new DefaultEventMetadata.Builder().withEventType(builder.eventType).withTimeReceived(builder.timeReceived).withAttributes(builder.eventMetadataAttributes).build() : builder.eventMetadata;
        this.jsonNode = this.getInitialJsonNode(builder.data);
    }

    protected JacksonEvent(JacksonEvent otherEvent) {
        this.jsonNode = otherEvent.jsonNode.deepCopy();
        this.eventMetadata = DefaultEventMetadata.fromEventMetadata(otherEvent.eventMetadata);
    }

    public static Event fromMessage(String message) {
        return JacksonEvent.builder().withEventType(EVENT_TYPE).withData(Collections.singletonMap(MESSAGE_KEY, message)).build();
    }

    private JsonNode getInitialJsonNode(Object data) {
        if (data == null) {
            return mapper.valueToTree(new HashMap());
        }
        if (data instanceof String) {
            try {
                return mapper.readTree((String)data);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to convert data into an event");
            }
        }
        return mapper.valueToTree(data);
    }

    protected JsonNode getJsonNode() {
        return this.jsonNode;
    }

    @Override
    public void put(String key, Object value) {
        String trimmedKey = this.checkAndTrimKey(key);
        LinkedList<String> keys = new LinkedList<String>(Arrays.asList(trimmedKey.split(SEPARATOR)));
        JsonNode parentNode = this.jsonNode;
        while (!keys.isEmpty()) {
            if (keys.size() == 1) {
                this.setNode(parentNode, keys.removeFirst(), value);
                continue;
            }
            String childKey = keys.removeFirst();
            if (childKey.isEmpty()) continue;
            parentNode = this.getOrCreateNode(parentNode, childKey);
        }
    }

    public void setEventHandle(EventHandle handle) {
        this.eventHandle = handle;
    }

    @Override
    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    private void setNode(JsonNode parentNode, String leafKey, Object value) {
        JsonNode valueNode = mapper.valueToTree(value);
        if (StringUtils.isNumeric((CharSequence)leafKey)) {
            ((ArrayNode)parentNode).set(Integer.parseInt(leafKey), valueNode);
        } else {
            ((ObjectNode)parentNode).set(leafKey, valueNode);
        }
    }

    private JsonNode getOrCreateNode(JsonNode node, String key) {
        JsonNode childNode = node.get(key);
        if (childNode == null) {
            childNode = mapper.createObjectNode();
            ((ObjectNode)node).set(key, childNode);
        }
        return childNode;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return this.mapNodeToObject(key, node, clazz);
    }

    private JsonNode getNode(String key) {
        JsonPointer jsonPointer = this.toJsonPointer(key);
        return this.jsonNode.at(jsonPointer);
    }

    private <T> T mapNodeToObject(String key, JsonNode node, Class<T> clazz) {
        try {
            return (T)mapper.treeToValue((TreeNode)node, clazz);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to map {} to {}", new Object[]{key, clazz, e});
            throw new RuntimeException(String.format("Unable to map %s to %s", key, clazz), e);
        }
    }

    @Override
    public <T> List<T> getList(String key, Class<T> clazz) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return this.mapNodeToList(key, node, clazz);
    }

    private <T> List<T> mapNodeToList(String key, JsonNode node, Class<T> clazz) {
        try {
            ObjectReader reader = mapper.readerFor((JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, clazz));
            return (List)reader.readValue(node);
        }
        catch (IOException e) {
            LOG.error("Unable to map {} to List of {}", new Object[]{key, clazz, e});
            throw new RuntimeException(String.format("Unable to map %s to %s", key, clazz), e);
        }
    }

    private JsonPointer toJsonPointer(String key) {
        String jsonPointerExpression = SEPARATOR + key;
        return JsonPointer.compile((String)jsonPointerExpression);
    }

    @Override
    public void delete(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        int index = trimmedKey.lastIndexOf(SEPARATOR);
        JsonNode baseNode = this.jsonNode;
        String leafKey = trimmedKey;
        if (index != -1) {
            JsonPointer jsonPointer = this.toJsonPointer(trimmedKey.substring(0, index));
            baseNode = this.jsonNode.at(jsonPointer);
            leafKey = trimmedKey.substring(index + 1);
        }
        if (!baseNode.isMissingNode()) {
            ((ObjectNode)baseNode).remove(leafKey);
        }
    }

    @Override
    public String toJsonString() {
        return this.jsonNode.toString();
    }

    @Override
    public String getAsJsonString(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        if (node.isMissingNode()) {
            return null;
        }
        return node.toString();
    }

    @Override
    public String formatString(String format) {
        int fromIndex = 0;
        Object result = "";
        int position = 0;
        while ((position = format.indexOf("${", fromIndex)) != -1) {
            int endPosition = format.indexOf("}", position + 1);
            if (endPosition == -1) {
                throw new RuntimeException("Format string is not properly formed");
            }
            result = (String)result + format.substring(fromIndex, position);
            String name = format.substring(position + 2, endPosition);
            Object val = this.get(name, Object.class);
            if (val == null) {
                throw new EventKeyNotFoundException(String.format("The key %s could not be found in the Event when formatting", name));
            }
            result = (String)result + val.toString();
            fromIndex = endPosition + 1;
        }
        if (fromIndex < format.length()) {
            result = (String)result + format.substring(fromIndex);
        }
        return result;
    }

    @Override
    public EventMetadata getMetadata() {
        return this.eventMetadata;
    }

    @Override
    public boolean containsKey(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        return !node.isMissingNode();
    }

    @Override
    public boolean isValueAList(String key) {
        String trimmedKey = this.checkAndTrimKey(key);
        JsonNode node = this.getNode(trimmedKey);
        return node.isArray();
    }

    @Override
    public Map<String, Object> toMap() {
        return (Map)mapper.convertValue((Object)this.jsonNode, MAP_TYPE_REFERENCE);
    }

    private String checkAndTrimKey(String key) {
        this.checkKey(key);
        return this.trimKey(key);
    }

    private void checkKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"key cannot be an empty string");
        if (key.length() > 2048) {
            throw new IllegalArgumentException("key cannot be longer than 2048 characters");
        }
        if (!this.isValidKey(key)) {
            throw new IllegalArgumentException("key " + key + " must contain only alphanumeric chars with .-_ and must follow JsonPointer (ie. 'field/to/key')");
        }
    }

    private String trimKey(String key) {
        String trimmedLeadingSlash = key.startsWith(SEPARATOR) ? key.substring(1) : key;
        return trimmedLeadingSlash.endsWith(SEPARATOR) ? trimmedLeadingSlash.substring(0, trimmedLeadingSlash.length() - 2) : trimmedLeadingSlash;
    }

    private boolean isValidKey(String key) {
        int previous = 32;
        int next = 32;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (i < key.length() - 1) {
                next = key.charAt(i + 1);
            }
            if (!(i != 0 && i != key.length() - 1 && previous != 47 && next != 47 || c != '_' && c != '.' && c != '-')) {
                return false;
            }
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '-' || c == '_' || c == '@' || c == '/')) {
                return false;
            }
            previous = c;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder(){

            public Builder getThis() {
                return this;
            }
        };
    }

    @Override
    public JsonStringBuilder jsonBuilder() {
        return new JsonStringBuilder(this);
    }

    public static JacksonEvent fromEvent(Event event) {
        if (event instanceof JacksonEvent) {
            return new JacksonEvent((JacksonEvent)event);
        }
        return JacksonEvent.builder().withData(event.toMap()).withEventMetadata(event.getMetadata()).build();
    }

    public class JsonStringBuilder
    extends Event.JsonStringBuilder {
        private Event event;

        private JsonStringBuilder(Event event) {
            Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
            this.event = event;
        }

        @Override
        public String toJsonString() {
            String jsonString = this.event.toJsonString().trim();
            String tagsKey = this.getTagsKey();
            if (tagsKey != null) {
                JsonNode tagsNode = mapper.valueToTree(this.event.getMetadata().getTags());
                return jsonString.substring(0, jsonString.length() - 1) + ",\"" + tagsKey + "\":" + tagsNode.toString() + "}";
            }
            return jsonString;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private EventMetadata eventMetadata;
        private Object data;
        private String eventType;
        private Instant timeReceived;
        private Map<String, Object> eventMetadataAttributes;

        public abstract T getThis();

        public Builder<T> withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder<T> withEventMetadataAttributes(Map<String, Object> eventMetadataAttributes) {
            this.eventMetadataAttributes = eventMetadataAttributes;
            return this;
        }

        public Builder<T> withTimeReceived(Instant timeReceived) {
            this.timeReceived = timeReceived;
            return this;
        }

        public Builder<T> withEventMetadata(EventMetadata eventMetadata) {
            this.eventMetadata = eventMetadata;
            return this;
        }

        public Builder<T> withData(Object data) {
            this.data = data;
            return this;
        }

        public JacksonEvent build() {
            return new JacksonEvent(this);
        }
    }
}

