/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.parquet.io.SeekableInputStream;
import org.opensearch.dataprepper.model.codec.DecompressionEngine;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.io.InputFile;
import org.opensearch.dataprepper.model.record.Record;

public interface InputCodec {
    public void parse(InputStream var1, Consumer<Record<Event>> var2) throws IOException;

    default public void parse(InputFile inputFile, DecompressionEngine decompressionEngine, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputFile);
        Objects.requireNonNull(eventConsumer);
        try (SeekableInputStream inputStream = inputFile.newStream();){
            this.parse(decompressionEngine.createInputStream((InputStream)inputStream), eventConsumer);
        }
    }
}

