/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.trace;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.opensearch.dataprepper.model.trace.TraceGroupFields;

public class DefaultTraceGroupFields
implements TraceGroupFields,
Serializable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String endTime;
    private Long durationInNanos;
    private Integer statusCode;

    DefaultTraceGroupFields() {
    }

    DefaultTraceGroupFields(String endTime, Long durationInNanos, Integer statusCode) {
        this.endTime = endTime;
        this.durationInNanos = durationInNanos;
        this.statusCode = statusCode;
    }

    private DefaultTraceGroupFields(Builder builder) {
        this.endTime = builder.endTime;
        this.durationInNanos = builder.durationInNanos;
        this.statusCode = builder.statusCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String json = OBJECT_MAPPER.writeValueAsString((Object)this);
        out.writeUTF(json);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String json = in.readUTF();
        DefaultTraceGroupFields temp = (DefaultTraceGroupFields)OBJECT_MAPPER.readValue(json, DefaultTraceGroupFields.class);
        this.endTime = temp.endTime;
        this.durationInNanos = temp.durationInNanos;
        this.statusCode = temp.statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTraceGroupFields that = (DefaultTraceGroupFields)o;
        return Objects.equals(this.endTime, that.endTime) && Objects.equals(this.durationInNanos, that.durationInNanos) && Objects.equals(this.statusCode, that.statusCode);
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public Long getDurationInNanos() {
        return this.durationInNanos;
    }

    @Override
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String endTime;
        private Long durationInNanos;
        private Integer statusCode;

        public Builder withEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withDurationInNanos(Long durationInNanos) {
            this.durationInNanos = durationInNanos;
            return this;
        }

        public Builder withStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public DefaultTraceGroupFields build() {
            return new DefaultTraceGroupFields(this);
        }
    }
}

