/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.opensearch.dataprepper.model.constraints.ByteCountMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ByteCountMinValidator
implements ConstraintValidator<ByteCountMin, ByteCount> {
    private ByteCount minByteCount;

    public void initialize(ByteCountMin constraint) {
        this.minByteCount = ByteCount.parse(constraint.value());
    }

    public boolean isValid(ByteCount byteCount, ConstraintValidatorContext context) {
        if (byteCount == null) {
            return true;
        }
        if (byteCount.compareTo(this.minByteCount) < 0) {
            if (context != null) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("The provided byte count %s is below minimum of %s", byteCount, this.minByteCount)).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

