/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import org.opensearch.dataprepper.expression.ExpressionEvaluationException;
import org.opensearch.dataprepper.expression.ExpressionParsingException;
import org.opensearch.dataprepper.model.event.Event;

public interface ExpressionEvaluator {
    public Object evaluate(String var1, Event var2);

    default public Boolean evaluateConditional(String statement, Event context) {
        try {
            Object result = this.evaluate(statement, context);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new ClassCastException("Unexpected expression return value of " + String.valueOf(result));
        }
        catch (ExpressionParsingException e) {
            throw e;
        }
        catch (ExpressionEvaluationException e) {
            return false;
        }
    }

    public Boolean isValidExpressionStatement(String var1);

    public Boolean isValidFormatExpression(String var1);

    public List<String> extractDynamicKeysFromFormatExpression(String var1);

    public List<String> extractDynamicExpressionsFromFormatExpression(String var1);
}

