/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.AbstractEventHandle;

public class AggregateEventHandle
extends AbstractEventHandle
implements Serializable {
    private List<WeakReference<AcknowledgementSet>> acknowledgementSetRefList = new ArrayList<WeakReference<AcknowledgementSet>>();
    private Set<Integer> acknowledgementSetHashes = new HashSet<Integer>();

    public AggregateEventHandle(Instant internalOriginationTime) {
        super(internalOriginationTime);
    }

    @Override
    public void addAcknowledgementSet(AcknowledgementSet acknowledgementSet) {
        int hashCode = acknowledgementSet.hashCode();
        if (!this.acknowledgementSetHashes.contains(hashCode)) {
            this.acknowledgementSetRefList.add(new WeakReference<AcknowledgementSet>(acknowledgementSet));
            this.acknowledgementSetHashes.add(hashCode);
        }
    }

    @Override
    public boolean hasAcknowledgementSet() {
        return this.acknowledgementSetRefList.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireReference() {
        AggregateEventHandle aggregateEventHandle = this;
        synchronized (aggregateEventHandle) {
            for (WeakReference<AcknowledgementSet> acknowledgementSetRef : this.acknowledgementSetRefList) {
                AcknowledgementSet acknowledgementSet = (AcknowledgementSet)acknowledgementSetRef.get();
                if (acknowledgementSet == null) continue;
                acknowledgementSet.acquire(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(boolean result) {
        this.notifyReleaseConsumers(result);
        boolean returnValue = true;
        AggregateEventHandle aggregateEventHandle = this;
        synchronized (aggregateEventHandle) {
            for (WeakReference<AcknowledgementSet> acknowledgementSetRef : this.acknowledgementSetRefList) {
                AcknowledgementSet acknowledgementSet = (AcknowledgementSet)acknowledgementSetRef.get();
                if (acknowledgementSet != null) {
                    acknowledgementSet.release(this, result);
                    continue;
                }
                returnValue = false;
            }
        }
        return returnValue;
    }

    List<WeakReference<AcknowledgementSet>> getAcknowledgementSetRefs() {
        return this.acknowledgementSetRefList;
    }
}

