/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.trace;

import com.amazon.dataprepper.model.trace.Link;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class DefaultLink
implements Link {
    private String traceId;
    private String spanId;
    private String traceState;
    private Map<String, Object> attributes;
    private Integer droppedAttributesCount;

    DefaultLink() {
    }

    private DefaultLink(Builder builder) {
        Preconditions.checkNotNull((Object)builder.traceId, (Object)"traceId cannot be null");
        Preconditions.checkArgument((!builder.traceId.isEmpty() ? 1 : 0) != 0, (Object)"traceId cannot be an empty string");
        this.traceId = builder.traceId;
        Preconditions.checkNotNull((Object)builder.spanId, (Object)"spanId cannot be null");
        Preconditions.checkArgument((!builder.spanId.isEmpty() ? 1 : 0) != 0, (Object)"spanId cannot be an empty String");
        this.spanId = builder.spanId;
        Preconditions.checkNotNull((Object)builder.traceState, (Object)"traceState cannot be null");
        Preconditions.checkArgument((!builder.traceState.isEmpty() ? 1 : 0) != 0, (Object)"traceState cannot be an empty String");
        this.traceState = builder.traceState;
        this.attributes = builder.attributes == null ? new HashMap() : builder.attributes;
        this.droppedAttributesCount = builder.droppedAttributesCount == null ? 0 : builder.droppedAttributesCount;
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public String getTraceState() {
        return this.traceState;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Integer getDroppedAttributesCount() {
        return this.droppedAttributesCount;
    }

    public boolean equals(Object other) {
        if (other instanceof DefaultLink) {
            DefaultLink o = (DefaultLink)other;
            return this.traceId.equals(o.traceId) && this.spanId.equals(o.spanId) && this.traceState.equals(o.traceState) && this.attributes.equals(o.attributes) && this.droppedAttributesCount.equals(o.droppedAttributesCount);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String traceId;
        private String spanId;
        private String traceState;
        private Map<String, Object> attributes;
        private Integer droppedAttributesCount;

        public Builder withTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder withSpanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder withTraceState(String traceState) {
            this.traceState = traceState;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withDroppedAttributesCount(Integer droppedAttributesCount) {
            this.droppedAttributesCount = droppedAttributesCount;
            return this;
        }

        public DefaultLink build() {
            return new DefaultLink(this);
        }
    }
}

