/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.metric;

import com.amazon.dataprepper.model.event.JacksonEvent;
import com.amazon.dataprepper.model.metric.Metric;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class JacksonMetric
extends JacksonEvent
implements Metric {
    protected static final String NAME_KEY = "name";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String START_TIME_KEY = "startTime";
    protected static final String TIME_KEY = "time";
    protected static final String SERVICE_NAME_KEY = "serviceName";
    protected static final String KIND_KEY = "kind";
    protected static final String UNIT_KEY = "unit";
    protected static final String ATTRIBUTES_KEY = "attributes";

    protected JacksonMetric(Builder builder) {
        super(builder);
    }

    @Override
    public String toJsonString() {
        ObjectNode attributesNode = (ObjectNode)this.getJsonNode().get(ATTRIBUTES_KEY);
        ObjectNode flattenedJsonNode = (ObjectNode)this.getJsonNode().deepCopy();
        if (attributesNode != null) {
            flattenedJsonNode.remove(ATTRIBUTES_KEY);
            Iterator it = attributesNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String field = (String)entry.getKey();
                if (flattenedJsonNode.has(field)) continue;
                flattenedJsonNode.set(field, (JsonNode)entry.getValue());
            }
        }
        return flattenedJsonNode.toString();
    }

    @Override
    public String getServiceName() {
        return this.get(SERVICE_NAME_KEY, String.class);
    }

    @Override
    public String getName() {
        return this.get(NAME_KEY, String.class);
    }

    @Override
    public String getDescription() {
        return this.get(DESCRIPTION_KEY, String.class);
    }

    @Override
    public String getUnit() {
        return this.get(UNIT_KEY, String.class);
    }

    @Override
    public String getKind() {
        return this.get(KIND_KEY, String.class);
    }

    @Override
    public String getStartTime() {
        return this.get(START_TIME_KEY, String.class);
    }

    @Override
    public String getTime() {
        return this.get(TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.get(ATTRIBUTES_KEY, Map.class);
    }

    public static abstract class Builder<T extends JacksonEvent.Builder<T>>
    extends JacksonEvent.Builder<T> {
        protected final Map<String, Object> data = new HashMap<String, Object>();

        public T withEventKind(String kind) {
            this.data.put(JacksonMetric.KIND_KEY, kind);
            return this.getThis();
        }

        public T withUnit(String unit) {
            this.data.put(JacksonMetric.UNIT_KEY, unit);
            return this.getThis();
        }

        public T withAttributes(Map<String, Object> attributes) {
            this.data.put(JacksonMetric.ATTRIBUTES_KEY, attributes);
            return this.getThis();
        }

        public T withName(String name) {
            this.data.put(JacksonMetric.NAME_KEY, name);
            return this.getThis();
        }

        public T withDescription(String description) {
            this.data.put(JacksonMetric.DESCRIPTION_KEY, description);
            return this.getThis();
        }

        public T withStartTime(String startTime) {
            this.data.put(JacksonMetric.START_TIME_KEY, startTime);
            return this.getThis();
        }

        public T withTime(String time) {
            this.data.put(JacksonMetric.TIME_KEY, time);
            return this.getThis();
        }

        public T withServiceName(String serviceName) {
            this.data.put(JacksonMetric.SERVICE_NAME_KEY, serviceName);
            return this.getThis();
        }
    }
}

