/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.trace;

import com.amazon.dataprepper.model.event.EventType;
import com.amazon.dataprepper.model.event.JacksonEvent;
import com.amazon.dataprepper.model.trace.DefaultLink;
import com.amazon.dataprepper.model.trace.DefaultSpanEvent;
import com.amazon.dataprepper.model.trace.DefaultTraceGroupFields;
import com.amazon.dataprepper.model.trace.Link;
import com.amazon.dataprepper.model.trace.Span;
import com.amazon.dataprepper.model.trace.SpanEvent;
import com.amazon.dataprepper.model.trace.TraceGroupFields;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JacksonSpan
extends JacksonEvent
implements Span {
    private static final String TRACE_ID_KEY = "traceId";
    private static final String SPAN_ID_KEY = "spanId";
    private static final String TRACE_STATE_KEY = "traceState";
    private static final String PARENT_SPAN_ID_KEY = "parentSpanId";
    private static final String NAME_KEY = "name";
    private static final String KIND_KEY = "kind";
    private static final String START_TIME_KEY = "startTime";
    private static final String END_TIME_KEY = "endTime";
    private static final String ATTRIBUTES_KEY = "attributes";
    private static final String DROPPED_ATTRIBUTES_COUNT_KEY = "droppedAttributesCount";
    private static final String EVENTS_KEY = "events";
    private static final String DROPPED_EVENTS_COUNT_KEY = "droppedEventsCount";
    private static final String LINKS_KEY = "links";
    private static final String DROPPED_LINKS_COUNT_KEY = "droppedLinksCount";
    private static final String SERVICE_NAME_KEY = "serviceName";
    private static final String TRACE_GROUP_KEY = "traceGroup";
    private static final String DURATION_IN_NANOS_KEY = "durationInNanos";
    private static final String TRACE_GROUP_FIELDS_KEY = "traceGroupFields";
    private static final List<String> REQUIRED_KEYS = Arrays.asList("traceGroup");
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("traceId", "spanId", "name", "kind", "startTime", "endTime");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Arrays.asList("durationInNanos", "traceGroupFields");

    protected JacksonSpan(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals("TRACE"), (Object)"eventType must be of type Trace");
    }

    @Override
    public String getTraceId() {
        return this.get(TRACE_ID_KEY, String.class);
    }

    @Override
    public String getSpanId() {
        return this.get(SPAN_ID_KEY, String.class);
    }

    @Override
    public String getTraceState() {
        return this.get(TRACE_STATE_KEY, String.class);
    }

    @Override
    public String getParentSpanId() {
        return this.get(PARENT_SPAN_ID_KEY, String.class);
    }

    @Override
    public String getName() {
        return this.get(NAME_KEY, String.class);
    }

    @Override
    public String getKind() {
        return this.get(KIND_KEY, String.class);
    }

    @Override
    public String getStartTime() {
        return this.get(START_TIME_KEY, String.class);
    }

    @Override
    public String getEndTime() {
        return this.get(END_TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.get(ATTRIBUTES_KEY, Map.class);
    }

    @Override
    public Integer getDroppedAttributesCount() {
        return this.get(DROPPED_ATTRIBUTES_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends SpanEvent> getEvents() {
        return this.getList(EVENTS_KEY, DefaultSpanEvent.class);
    }

    @Override
    public Integer getDroppedEventsCount() {
        return this.get(DROPPED_EVENTS_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends Link> getLinks() {
        return this.getList(LINKS_KEY, DefaultLink.class);
    }

    @Override
    public Integer getDroppedLinksCount() {
        return this.get(DROPPED_LINKS_COUNT_KEY, Integer.class);
    }

    @Override
    public String getTraceGroup() {
        return this.get(TRACE_GROUP_KEY, String.class);
    }

    @Override
    public Long getDurationInNanos() {
        return this.get(DURATION_IN_NANOS_KEY, Long.class);
    }

    @Override
    public TraceGroupFields getTraceGroupFields() {
        return this.get(TRACE_GROUP_FIELDS_KEY, DefaultTraceGroupFields.class);
    }

    @Override
    public String getServiceName() {
        return this.get(SERVICE_NAME_KEY, String.class);
    }

    @Override
    public void setTraceGroup(String traceGroup) {
        this.put(TRACE_GROUP_KEY, traceGroup);
    }

    @Override
    public void setTraceGroupFields(TraceGroupFields traceGroupFields) {
        this.put(TRACE_GROUP_FIELDS_KEY, traceGroupFields);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toJsonString() {
        ObjectNode attributesNode = (ObjectNode)this.getJsonNode().get(ATTRIBUTES_KEY);
        ObjectNode flattenedJsonNode = (ObjectNode)this.getJsonNode().deepCopy();
        if (attributesNode != null) {
            flattenedJsonNode.remove(ATTRIBUTES_KEY);
            Iterator it = attributesNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String field = (String)entry.getKey();
                if (flattenedJsonNode.has(field)) continue;
                flattenedJsonNode.set(field, (JsonNode)entry.getValue());
            }
        }
        return flattenedJsonNode.toString();
    }

    public static class Builder
    extends JacksonEvent.Builder<Builder> {
        private final Map<String, Object> data = new HashMap<String, Object>();

        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withSpanId(String spanId) {
            this.data.put(JacksonSpan.SPAN_ID_KEY, spanId);
            return this;
        }

        public Builder withTraceId(String traceId) {
            this.data.put(JacksonSpan.TRACE_ID_KEY, traceId);
            return this;
        }

        public Builder withTraceState(String traceState) {
            this.data.put(JacksonSpan.TRACE_STATE_KEY, traceState);
            return this;
        }

        public Builder withParentSpanId(String parentSpanId) {
            this.data.put(JacksonSpan.PARENT_SPAN_ID_KEY, parentSpanId);
            return this;
        }

        public Builder withName(String name) {
            this.data.put(JacksonSpan.NAME_KEY, name);
            return this;
        }

        public Builder withKind(String kind) {
            this.data.put(JacksonSpan.KIND_KEY, kind);
            return this;
        }

        public Builder withStartTime(String startTime) {
            this.data.put(JacksonSpan.START_TIME_KEY, startTime);
            return this;
        }

        public Builder withEndTime(String endTime) {
            this.data.put(JacksonSpan.END_TIME_KEY, endTime);
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.data.put(JacksonSpan.ATTRIBUTES_KEY, attributes);
            return this;
        }

        public Builder withDroppedAttributesCount(Integer droppedAttributesCount) {
            this.data.put(JacksonSpan.DROPPED_ATTRIBUTES_COUNT_KEY, droppedAttributesCount);
            return this;
        }

        public Builder withEvents(List<? extends SpanEvent> events) {
            this.data.put(JacksonSpan.EVENTS_KEY, events);
            return this;
        }

        public Builder withDroppedEventsCount(Integer droppedEventsCount) {
            this.data.put(JacksonSpan.DROPPED_EVENTS_COUNT_KEY, droppedEventsCount);
            return this;
        }

        public Builder withLinks(List<? extends Link> links) {
            this.data.put(JacksonSpan.LINKS_KEY, links);
            return this;
        }

        public Builder withDroppedLinksCount(Integer droppedLinksCount) {
            this.data.put(JacksonSpan.DROPPED_LINKS_COUNT_KEY, droppedLinksCount);
            return this;
        }

        public Builder withTraceGroup(String traceGroup) {
            this.data.put(JacksonSpan.TRACE_GROUP_KEY, traceGroup);
            return this;
        }

        public Builder withDurationInNanos(Long durationInNanos) {
            this.data.put(JacksonSpan.DURATION_IN_NANOS_KEY, durationInNanos);
            return this;
        }

        public Builder withTraceGroupFields(TraceGroupFields traceGroupFields) {
            this.data.put(JacksonSpan.TRACE_GROUP_FIELDS_KEY, traceGroupFields);
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.data.put(JacksonSpan.SERVICE_NAME_KEY, serviceName);
            return this;
        }

        @Override
        public JacksonSpan build() {
            this.validateParameters();
            this.checkAndSetDefaultValues();
            this.withData(this.data);
            this.withEventType(EventType.TRACE.toString());
            return new JacksonSpan(this);
        }

        private void validateParameters() {
            REQUIRED_KEYS.forEach(key -> Preconditions.checkState((boolean)this.data.containsKey(key), (Object)(key + " need to be assigned")));
            REQUIRED_NON_EMPTY_KEYS.forEach(key -> {
                String value = (String)this.data.get(key);
                Preconditions.checkNotNull((Object)value, (Object)(key + " cannot be null"));
                Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(key + " cannot be an empty string"));
            });
            REQUIRED_NON_NULL_KEYS.forEach(key -> {
                Object value = this.data.get(key);
                Preconditions.checkNotNull((Object)value, (Object)(key + " cannot be null"));
            });
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent(JacksonSpan.ATTRIBUTES_KEY, k -> new HashMap());
            this.data.putIfAbsent(JacksonSpan.DROPPED_ATTRIBUTES_COUNT_KEY, 0);
            this.data.computeIfAbsent(JacksonSpan.LINKS_KEY, k -> new LinkedList());
            this.data.putIfAbsent(JacksonSpan.DROPPED_LINKS_COUNT_KEY, 0);
            this.data.computeIfAbsent(JacksonSpan.EVENTS_KEY, k -> new LinkedList());
            this.data.putIfAbsent(JacksonSpan.DROPPED_EVENTS_COUNT_KEY, 0);
        }
    }
}

