/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.trace;

import com.amazon.dataprepper.model.trace.SpanEvent;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class DefaultSpanEvent
implements SpanEvent {
    private String name;
    private String time;
    private Map<String, Object> attributes;
    private Integer droppedAttributesCount;

    DefaultSpanEvent() {
    }

    private DefaultSpanEvent(Builder builder) {
        Preconditions.checkNotNull((Object)builder.name, (Object)"name cannot be null");
        Preconditions.checkArgument((!builder.name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be an empty string");
        this.name = builder.name;
        Preconditions.checkNotNull((Object)builder.time, (Object)"time cannot be null");
        Preconditions.checkArgument((!builder.time.isEmpty() ? 1 : 0) != 0, (Object)"time cannot be an empty string");
        this.time = builder.time;
        this.attributes = builder.attributes == null ? new HashMap() : builder.attributes;
        this.droppedAttributesCount = builder.droppedAttributesCount == null ? 0 : builder.droppedAttributesCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Integer getDroppedAttributesCount() {
        return this.droppedAttributesCount;
    }

    public boolean equals(Object other) {
        if (other instanceof DefaultSpanEvent) {
            DefaultSpanEvent o = (DefaultSpanEvent)other;
            return this.name.equals(o.name) && this.time.equals(o.time) && this.attributes.equals(o.attributes) && this.droppedAttributesCount.equals(o.droppedAttributesCount);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String time;
        private Map<String, Object> attributes;
        private Integer droppedAttributesCount;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTime(String time) {
            this.time = time;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withDroppedAttributesCount(Integer droppedAttributesCount) {
            this.droppedAttributesCount = droppedAttributesCount;
            return this;
        }

        public DefaultSpanEvent build() {
            return new DefaultSpanEvent(this);
        }
    }
}

