/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.metric;

import com.amazon.dataprepper.model.event.EventType;
import com.amazon.dataprepper.model.metric.JacksonMetric;
import com.amazon.dataprepper.model.metric.Metric;
import com.amazon.dataprepper.model.metric.ParameterValidator;
import com.amazon.dataprepper.model.metric.Sum;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class JacksonSum
extends JacksonMetric
implements Sum {
    private static final String VALUE_KEY = "value";
    private static final String AGGREGATION_TEMPORALITY_KEY = "aggregationTemporality";
    private static final String IS_MONOTONIC_KEY = "isMonotonic";
    private static final List<String> REQUIRED_KEYS = new ArrayList<String>();
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Arrays.asList("value", "isMonotonic");

    protected JacksonSum(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Double getValue() {
        return this.get(VALUE_KEY, Double.class);
    }

    @Override
    public String getAggregationTemporality() {
        return this.get(AGGREGATION_TEMPORALITY_KEY, String.class);
    }

    @Override
    public boolean isMonotonic() {
        return this.get(IS_MONOTONIC_KEY, Boolean.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withValue(Double value) {
            if (value != null) {
                this.data.put(JacksonSum.VALUE_KEY, value);
            }
            return this;
        }

        public Builder withAggregationTemporality(String aggregationTemporality) {
            this.data.put(JacksonSum.AGGREGATION_TEMPORALITY_KEY, aggregationTemporality);
            return this;
        }

        public Builder withIsMonotonic(boolean isMonotonic) {
            this.data.put(JacksonSum.IS_MONOTONIC_KEY, isMonotonic);
            return this;
        }

        @Override
        public JacksonSum build() {
            this.withData(this.data);
            this.withEventType(EventType.METRIC.toString());
            this.withEventKind(Metric.KIND.SUM.toString());
            this.checkAndSetDefaultValues();
            new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, this.data);
            return new JacksonSum(this);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent("attributes", k -> new HashMap());
        }
    }
}

