/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.buffer;

import com.amazon.dataprepper.metrics.PluginMetrics;
import com.amazon.dataprepper.model.CheckpointState;
import com.amazon.dataprepper.model.buffer.Buffer;
import com.amazon.dataprepper.model.configuration.PluginSetting;
import com.amazon.dataprepper.model.record.Record;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractBuffer<T extends Record<?>>
implements Buffer<T> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsWrittenCounter;
    private final Counter recordsReadCounter;
    private final AtomicLong recordsInFlight;
    private final AtomicLong recordsInBuffer;
    private final Counter recordsProcessedCounter;
    private final Counter writeTimeoutCounter;
    private final Timer writeTimer;
    private final Timer readTimer;
    private final Timer checkpointTimer;

    public AbstractBuffer(PluginSetting pluginSetting) {
        this(PluginMetrics.fromPluginSetting(pluginSetting), pluginSetting.getPipelineName());
    }

    public AbstractBuffer(String bufferName, String pipelineName) {
        this(PluginMetrics.fromNames(bufferName, pipelineName), pipelineName);
    }

    private AbstractBuffer(PluginMetrics pluginMetrics, String pipelineName) {
        this.pluginMetrics = pluginMetrics;
        this.recordsWrittenCounter = pluginMetrics.counter("recordsWritten");
        this.recordsReadCounter = pluginMetrics.counter("recordsRead");
        this.recordsInFlight = pluginMetrics.gauge("recordsInFlight", new AtomicLong());
        this.recordsInBuffer = pluginMetrics.gauge("recordsInBuffer", new AtomicLong());
        this.recordsProcessedCounter = pluginMetrics.counter("recordsProcessed", pipelineName);
        this.writeTimeoutCounter = pluginMetrics.counter("writeTimeouts");
        this.writeTimer = pluginMetrics.timer("writeTimeElapsed");
        this.readTimer = pluginMetrics.timer("readTimeElapsed");
        this.checkpointTimer = pluginMetrics.timer("checkpointTimeElapsed");
    }

    @Override
    public void write(T record, int timeoutInMillis) throws TimeoutException {
        long startTime = System.nanoTime();
        try {
            this.doWrite(record, timeoutInMillis);
            this.recordsWrittenCounter.increment();
            this.recordsInBuffer.incrementAndGet();
        }
        catch (TimeoutException e) {
            this.writeTimeoutCounter.increment();
            throw e;
        }
        finally {
            this.writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void writeAll(Collection<T> records, int timeoutInMillis) throws Exception {
        long startTime = System.nanoTime();
        try {
            int size = records.size();
            this.doWriteAll(records, timeoutInMillis);
            this.recordsWrittenCounter.increment((double)size);
            this.recordsInBuffer.addAndGet(size);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                this.writeTimeoutCounter.increment();
            }
            throw e;
        }
        finally {
            this.writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public Map.Entry<Collection<T>, CheckpointState> read(int timeoutInMillis) {
        Map.Entry readResult = (Map.Entry)this.readTimer.record(() -> this.doRead(timeoutInMillis));
        this.recordsReadCounter.increment((double)((Collection)readResult.getKey()).size() * 1.0);
        this.recordsInFlight.addAndGet(((CheckpointState)readResult.getValue()).getNumRecordsToBeChecked());
        this.recordsInBuffer.addAndGet(-1 * ((CheckpointState)readResult.getValue()).getNumRecordsToBeChecked());
        return readResult;
    }

    @Override
    public void checkpoint(CheckpointState checkpointState) {
        this.checkpointTimer.record(() -> this.doCheckpoint(checkpointState));
        int numRecordsToBeChecked = checkpointState.getNumRecordsToBeChecked();
        this.recordsInFlight.addAndGet(-numRecordsToBeChecked);
        this.recordsProcessedCounter.increment((double)numRecordsToBeChecked);
    }

    protected int getRecordsInFlight() {
        return this.recordsInFlight.intValue();
    }

    public abstract void doWrite(T var1, int var2) throws TimeoutException;

    public abstract void doWriteAll(Collection<T> var1, int var2) throws Exception;

    public abstract Map.Entry<Collection<T>, CheckpointState> doRead(int var1);

    public abstract void doCheckpoint(CheckpointState var1);

    @Override
    public abstract boolean isEmpty();
}

