/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.sink;

import com.amazon.dataprepper.metrics.PluginMetrics;
import com.amazon.dataprepper.model.configuration.PluginSetting;
import com.amazon.dataprepper.model.record.Record;
import com.amazon.dataprepper.model.sink.Sink;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;

public abstract class AbstractSink<T extends Record<?>>
implements Sink<T> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsInCounter;
    private final Timer timeElapsedTimer;

    public AbstractSink(PluginSetting pluginSetting) {
        this.pluginMetrics = PluginMetrics.fromPluginSetting(pluginSetting);
        this.recordsInCounter = this.pluginMetrics.counter("recordsIn");
        this.timeElapsedTimer = this.pluginMetrics.timer("timeElapsed");
    }

    @Override
    public void output(Collection<T> records) {
        this.recordsInCounter.increment((double)records.size() * 1.0);
        this.timeElapsedTimer.record(() -> this.doOutput(records));
    }

    public abstract void doOutput(Collection<T> var1);
}

