/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.client.indices.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.index.TemplateResponseData;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ResponseConverter {
    private ResponseConverter() {
    }

    public static Map<String, Set<AliasData>> aliasDatas(Map<String, Set<AliasMetadata>> aliasesMetadatas) {
        LinkedHashMap<String, Set<AliasData>> converted = new LinkedHashMap<String, Set<AliasData>>();
        aliasesMetadatas.forEach((index, aliasMetaDataSet) -> {
            LinkedHashSet aliasDataSet = new LinkedHashSet();
            aliasMetaDataSet.forEach(aliasMetaData -> aliasDataSet.add(ResponseConverter.toAliasData(aliasMetaData)));
            converted.put((String)index, aliasDataSet);
        });
        return converted;
    }

    public static AliasData toAliasData(AliasMetadata aliasMetaData) {
        StringQuery filterQuery = null;
        CompressedXContent aliasMetaDataFilter = aliasMetaData.getFilter();
        if (aliasMetaDataFilter != null) {
            filterQuery = StringQuery.builder((String)aliasMetaDataFilter.string()).build();
        }
        return AliasData.of((String)aliasMetaData.alias(), (Query)filterQuery, (String)aliasMetaData.indexRouting(), (String)aliasMetaData.getSearchRouting(), (Boolean)aliasMetaData.writeIndex(), (Boolean)aliasMetaData.isHidden());
    }

    public static List<IndexInformation> getIndexInformations(org.opensearch.client.indices.GetIndexResponse getIndexResponse) {
        Assert.notNull((Object)getIndexResponse, (String)"getIndexResponse must not be null");
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        for (String indexName : getIndexResponse.getIndices()) {
            org.springframework.data.elasticsearch.core.index.Settings settings = ResponseConverter.settingsFromGetIndexResponse(getIndexResponse, indexName);
            Document mappings = ResponseConverter.mappingsFromGetIndexResponse(getIndexResponse, indexName);
            List<AliasData> aliases = ResponseConverter.aliasDataFromIndexResponse(getIndexResponse, indexName);
            indexInformationList.add(IndexInformation.of((String)indexName, (org.springframework.data.elasticsearch.core.index.Settings)settings, (Document)mappings, aliases));
        }
        return indexInformationList;
    }

    private static org.springframework.data.elasticsearch.core.index.Settings settingsFromGetIndexResponse(org.opensearch.client.indices.GetIndexResponse getIndexResponse, String indexName) {
        org.springframework.data.elasticsearch.core.index.Settings settings = new org.springframework.data.elasticsearch.core.index.Settings();
        Settings indexSettings = (Settings)getIndexResponse.getSettings().get(indexName);
        if (!indexSettings.isEmpty()) {
            for (String key : indexSettings.keySet()) {
                settings.put(key, (Object)indexSettings.get(key));
            }
        }
        return settings;
    }

    private static Document mappingsFromGetIndexResponse(org.opensearch.client.indices.GetIndexResponse getIndexResponse, String indexName) {
        Document document = Document.create();
        if (getIndexResponse.getMappings().containsKey(indexName)) {
            MappingMetadata mappings = (MappingMetadata)getIndexResponse.getMappings().get(indexName);
            document = Document.from((Map)mappings.getSourceAsMap());
        }
        return document;
    }

    private static List<AliasData> aliasDataFromIndexResponse(org.opensearch.client.indices.GetIndexResponse getIndexResponse, String indexName) {
        List<Object> aliases = Collections.emptyList();
        if (getIndexResponse.getAliases().get(indexName) != null) {
            aliases = ((List)getIndexResponse.getAliases().get(indexName)).stream().map(ResponseConverter::toAliasData).collect(Collectors.toList());
        }
        return aliases;
    }

    public static List<IndexInformation> getIndexInformations(GetIndexResponse getIndexResponse) {
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        for (String indexName : getIndexResponse.getIndices()) {
            org.springframework.data.elasticsearch.core.index.Settings settings = ResponseConverter.settingsFromGetIndexResponse(getIndexResponse, indexName);
            Document mappings = ResponseConverter.mappingsFromGetIndexResponse(getIndexResponse, indexName);
            List<AliasData> aliases = ResponseConverter.aliasDataFromIndexResponse(getIndexResponse, indexName);
            indexInformationList.add(IndexInformation.of((String)indexName, (org.springframework.data.elasticsearch.core.index.Settings)settings, (Document)mappings, aliases));
        }
        return indexInformationList;
    }

    private static org.springframework.data.elasticsearch.core.index.Settings settingsFromGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        org.springframework.data.elasticsearch.core.index.Settings settings = new org.springframework.data.elasticsearch.core.index.Settings();
        if (getIndexResponse.getSettings().containsKey(indexName)) {
            Settings indexSettings = (Settings)getIndexResponse.getSettings().get(indexName);
            for (String key : indexSettings.keySet()) {
                settings.put(key, (Object)indexSettings.get(key));
            }
        }
        return settings;
    }

    private static Document mappingsFromGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        MappingMetadata mappings;
        Document document = Document.create();
        boolean responseHasMappings = getIndexResponse.getMappings().containsKey(indexName);
        if (responseHasMappings && (mappings = (MappingMetadata)getIndexResponse.getMappings().get(indexName)) != null) {
            document = Document.from((Map)mappings.getSourceAsMap());
        }
        return document;
    }

    private static List<AliasData> aliasDataFromIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        List<Object> aliases = Collections.emptyList();
        if (getIndexResponse.getAliases().get(indexName) != null) {
            aliases = ((List)getIndexResponse.getAliases().get(indexName)).stream().map(ResponseConverter::toAliasData).collect(Collectors.toList());
        }
        return aliases;
    }

    @Nullable
    public static TemplateData getTemplateData(GetIndexTemplatesResponse getIndexTemplatesResponse, String templateName) {
        for (IndexTemplateMetadata indexTemplateMetadata : getIndexTemplatesResponse.getIndexTemplates()) {
            if (!indexTemplateMetadata.name().equals(templateName)) continue;
            org.springframework.data.elasticsearch.core.index.Settings settings = ResponseConverter.extracSettingsFromMetaData(indexTemplateMetadata);
            LinkedHashMap<String, AliasData> aliases = new LinkedHashMap<String, AliasData>();
            Map aliasesResponse = indexTemplateMetadata.aliases();
            for (String key : aliasesResponse.keySet()) {
                aliases.put(key, ResponseConverter.toAliasData((AliasMetadata)aliasesResponse.get(key)));
            }
            return TemplateData.builder().withIndexPatterns(indexTemplateMetadata.patterns().toArray(new String[0])).withSettings((Map)settings).withMapping(Document.from((Map)indexTemplateMetadata.mappings().getSourceAsMap())).withAliases(aliases).withOrder(indexTemplateMetadata.order()).withVersion(indexTemplateMetadata.version()).build();
        }
        return null;
    }

    @Nullable
    public static TemplateResponse getTemplateResponse(GetIndexTemplatesResponse getIndexTemplatesResponse, String templateName) {
        for (IndexTemplateMetadata indexTemplateMetadata : getIndexTemplatesResponse.getIndexTemplates()) {
            if (!indexTemplateMetadata.name().equals(templateName)) continue;
            org.springframework.data.elasticsearch.core.index.Settings settings = ResponseConverter.extracSettingsFromMetaData(indexTemplateMetadata);
            Map<String, AliasData> aliases = ResponseConverter.extractAliasesFromMetaData(indexTemplateMetadata);
            return TemplateResponse.builder().withName(indexTemplateMetadata.name()).withTemplateData(TemplateResponseData.builder().withAliases(aliases).withSettings(settings).withMapping(Document.from((Map)indexTemplateMetadata.mappings().getSourceAsMap())).build()).build();
        }
        return null;
    }

    private static org.springframework.data.elasticsearch.core.index.Settings extracSettingsFromMetaData(IndexTemplateMetadata indexTemplateMetadata) {
        org.springframework.data.elasticsearch.core.index.Settings esSettings = new org.springframework.data.elasticsearch.core.index.Settings();
        Settings osSettings = indexTemplateMetadata.settings();
        osSettings.keySet().forEach(key -> esSettings.put(key, (Object)osSettings.get(key)));
        return esSettings;
    }

    private static Map<String, AliasData> extractAliasesFromMetaData(IndexTemplateMetadata indexTemplateMetadata) {
        LinkedHashMap<String, AliasData> aliases = new LinkedHashMap<String, AliasData>();
        Map aliasesResponse = indexTemplateMetadata.aliases();
        for (String key : aliasesResponse.keySet()) {
            aliases.put(key, ResponseConverter.toAliasData((AliasMetadata)aliasesResponse.get(key)));
        }
        return aliases;
    }

    public static org.springframework.data.elasticsearch.core.index.Settings fromSettingsResponse(GetSettingsResponse response, String indexName) {
        org.springframework.data.elasticsearch.core.index.Settings settings = new org.springframework.data.elasticsearch.core.index.Settings();
        if (!response.getIndexToDefaultSettings().isEmpty()) {
            Settings defaultSettings = (Settings)response.getIndexToDefaultSettings().get(indexName);
            for (String key : defaultSettings.keySet()) {
                settings.put(key, (Object)defaultSettings.get(key));
            }
        }
        if (!response.getIndexToSettings().isEmpty()) {
            Settings customSettings = (Settings)response.getIndexToSettings().get(indexName);
            for (String key : customSettings.keySet()) {
                settings.put(key, (Object)customSettings.get(key));
            }
        }
        return settings;
    }

    @Nullable
    public static MultiGetItem.Failure getFailure(MultiGetItemResponse itemResponse) {
        MultiGetResponse.Failure responseFailure = itemResponse.getFailure();
        return responseFailure != null ? MultiGetItem.Failure.of((String)responseFailure.getIndex(), (String)"_doc", (String)responseFailure.getId(), (Exception)responseFailure.getFailure(), null) : null;
    }

    public static ClusterHealth clusterHealth(ClusterHealthResponse clusterHealthResponse) {
        return ClusterHealth.builder().withActivePrimaryShards(clusterHealthResponse.getActivePrimaryShards()).withActiveShards(clusterHealthResponse.getActiveShards()).withActiveShardsPercent(clusterHealthResponse.getActiveShardsPercent()).withClusterName(clusterHealthResponse.getClusterName()).withDelayedUnassignedShards(clusterHealthResponse.getDelayedUnassignedShards()).withInitializingShards(clusterHealthResponse.getInitializingShards()).withNumberOfDataNodes(clusterHealthResponse.getNumberOfDataNodes()).withNumberOfInFlightFetch(clusterHealthResponse.getNumberOfInFlightFetch()).withNumberOfNodes(clusterHealthResponse.getNumberOfNodes()).withNumberOfPendingTasks(clusterHealthResponse.getNumberOfPendingTasks()).withRelocatingShards(clusterHealthResponse.getRelocatingShards()).withStatus(clusterHealthResponse.getStatus().toString()).withTaskMaxWaitingTimeMillis(clusterHealthResponse.getTaskMaxWaitingTime().millis()).withTimedOut(clusterHealthResponse.isTimedOut()).withUnassignedShards(clusterHealthResponse.getUnassignedShards()).build();
    }

    public static ByQueryResponse byQueryResponseOf(BulkByScrollResponse bulkByScrollResponse) {
        List failures = bulkByScrollResponse.getBulkFailures().stream().map(ResponseConverter::byQueryResponseFailureOf).collect(Collectors.toList());
        List searchFailures = bulkByScrollResponse.getSearchFailures().stream().map(ResponseConverter::byQueryResponseSearchFailureOf).collect(Collectors.toList());
        return ByQueryResponse.builder().withTook(bulkByScrollResponse.getTook().getMillis()).withTimedOut(bulkByScrollResponse.isTimedOut()).withTotal(bulkByScrollResponse.getTotal()).withUpdated(bulkByScrollResponse.getUpdated()).withDeleted(bulkByScrollResponse.getDeleted()).withBatches(bulkByScrollResponse.getBatches()).withVersionConflicts(bulkByScrollResponse.getVersionConflicts()).withNoops(bulkByScrollResponse.getNoops()).withBulkRetries(bulkByScrollResponse.getBulkRetries()).withSearchRetries(bulkByScrollResponse.getSearchRetries()).withReasonCancelled(bulkByScrollResponse.getReasonCancelled()).withFailures(failures).withSearchFailure(searchFailures).build();
    }

    public static ByQueryResponse.Failure byQueryResponseFailureOf(BulkItemResponse.Failure failure) {
        return ByQueryResponse.Failure.builder().withIndex(failure.getIndex()).withId(failure.getId()).withStatus(Integer.valueOf(failure.getStatus().getStatus())).withAborted(Boolean.valueOf(failure.isAborted())).withCause(failure.getCause()).withSeqNo(Long.valueOf(failure.getSeqNo())).withTerm(Long.valueOf(failure.getTerm())).build();
    }

    public static ByQueryResponse.SearchFailure byQueryResponseSearchFailureOf(ScrollableHitSource.SearchFailure searchFailure) {
        return ByQueryResponse.SearchFailure.builder((Throwable)searchFailure.getReason()).withReason(searchFailure.getReason()).withIndex(searchFailure.getIndex()).withNodeId(searchFailure.getNodeId()).withShardId(searchFailure.getShardId()).withStatus(Integer.valueOf(searchFailure.getStatus().getStatus())).build();
    }

    public static ReindexResponse reindexResponseOf(BulkByScrollResponse bulkByScrollResponse) {
        List failures = bulkByScrollResponse.getBulkFailures().stream().map(ResponseConverter::reindexResponseFailureOf).collect(Collectors.toList());
        return ReindexResponse.builder().withTook(bulkByScrollResponse.getTook().getMillis()).withTimedOut(bulkByScrollResponse.isTimedOut()).withTotal(bulkByScrollResponse.getTotal()).withCreated(bulkByScrollResponse.getCreated()).withUpdated(bulkByScrollResponse.getUpdated()).withDeleted(bulkByScrollResponse.getDeleted()).withBatches((long)bulkByScrollResponse.getBatches()).withVersionConflicts(bulkByScrollResponse.getVersionConflicts()).withNoops(bulkByScrollResponse.getNoops()).withBulkRetries(bulkByScrollResponse.getBulkRetries()).withSearchRetries(bulkByScrollResponse.getSearchRetries()).withThrottledMillis(bulkByScrollResponse.getStatus().getThrottled().getMillis()).withRequestsPerSecond((double)bulkByScrollResponse.getStatus().getRequestsPerSecond()).withThrottledUntilMillis(bulkByScrollResponse.getStatus().getThrottledUntil().getMillis()).withFailures(failures).build();
    }

    public static ReindexResponse.Failure reindexResponseFailureOf(BulkItemResponse.Failure failure) {
        return ReindexResponse.Failure.builder().withIndex(failure.getIndex()).withId(failure.getId()).withStatus(Integer.valueOf(failure.getStatus().getStatus())).withAborted(Boolean.valueOf(failure.isAborted())).withCause(failure.getCause()).withSeqNo(Long.valueOf(failure.getSeqNo())).withTerm(Long.valueOf(failure.getTerm())).build();
    }

    @Nullable
    static ElasticsearchErrorCause toErrorCause(String reason, @Nullable Throwable errorCause) {
        if (errorCause != null) {
            try (PrintWriter writer = new PrintWriter(new StringWriter());){
                errorCause.printStackTrace(writer);
                writer.flush();
                ElasticsearchErrorCause elasticsearchErrorCause = new ElasticsearchErrorCause(null, reason, writer.toString(), ResponseConverter.toErrorCause(reason, errorCause.getCause()), List.of(), Arrays.stream(errorCause.getSuppressed()).map(s -> ResponseConverter.toErrorCause(reason, s)).collect(Collectors.toList()));
                return elasticsearchErrorCause;
            }
        }
        return null;
    }
}

