/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteScriptRequest;
import org.opensearch.client.opensearch.core.ExistsRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.GetScriptRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.MgetRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.MsearchRequest;
import org.opensearch.client.opensearch.core.MsearchResponse;
import org.opensearch.client.opensearch.core.MsearchTemplateRequest;
import org.opensearch.client.opensearch.core.MsearchTemplateResponse;
import org.opensearch.client.opensearch.core.PutScriptRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.SearchTemplateRequest;
import org.opensearch.client.opensearch.core.SearchTemplateResponse;
import org.opensearch.client.opensearch.core.UpdateByQueryRequest;
import org.opensearch.client.opensearch.core.UpdateByQueryResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.msearch.MultiSearchResponseItem;
import org.opensearch.client.opensearch.core.pit.CreatePitRequest;
import org.opensearch.client.opensearch.core.pit.DeletePitRequest;
import org.opensearch.client.opensearch.core.pit.DeletePitResponse;
import org.opensearch.client.opensearch.core.search.SearchResult;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.Version;
import org.opensearch.data.client.osc.ClusterTemplate;
import org.opensearch.data.client.osc.DocumentAdapters;
import org.opensearch.data.client.osc.EntityAsMap;
import org.opensearch.data.client.osc.IndicesTemplate;
import org.opensearch.data.client.osc.NativeQuery;
import org.opensearch.data.client.osc.NativeQueryBuilder;
import org.opensearch.data.client.osc.OpenSearchExceptionTranslator;
import org.opensearch.data.client.osc.RequestConverter;
import org.opensearch.data.client.osc.ResponseConverter;
import org.opensearch.data.client.osc.SearchDocumentResponseBuilder;
import org.opensearch.data.client.osc.TypeUtils;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.client.UnsupportedBackendOperation;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.cluster.ClusterOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SearchTemplateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.data.elasticsearch.core.script.Script;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenSearchTemplate
extends AbstractElasticsearchTemplate {
    private static final Log LOGGER = LogFactory.getLog(OpenSearchTemplate.class);
    private final OpenSearchClient client;
    private final RequestConverter requestConverter;
    private final ResponseConverter responseConverter;
    private final JsonpMapper jsonpMapper;
    private final OpenSearchExceptionTranslator exceptionTranslator;

    public OpenSearchTemplate(OpenSearchClient client) {
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
        this.jsonpMapper = ((OpenSearchTransport)client._transport()).jsonpMapper();
        this.requestConverter = new RequestConverter(this.elasticsearchConverter, this.jsonpMapper);
        this.responseConverter = new ResponseConverter(this.jsonpMapper);
        this.exceptionTranslator = new OpenSearchExceptionTranslator(this.jsonpMapper);
    }

    public OpenSearchTemplate(OpenSearchClient client, ElasticsearchConverter elasticsearchConverter) {
        super(elasticsearchConverter);
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
        this.jsonpMapper = ((OpenSearchTransport)client._transport()).jsonpMapper();
        this.requestConverter = new RequestConverter(elasticsearchConverter, this.jsonpMapper);
        this.responseConverter = new ResponseConverter(this.jsonpMapper);
        this.exceptionTranslator = new OpenSearchExceptionTranslator(this.jsonpMapper);
    }

    protected AbstractElasticsearchTemplate doCopy() {
        return new OpenSearchTemplate(this.client, this.elasticsearchConverter);
    }

    public IndexOperations indexOps(Class<?> clazz) {
        return new IndicesTemplate(this.client.indices(), this.getClusterTemplate(), this.elasticsearchConverter, clazz);
    }

    public IndexOperations indexOps(IndexCoordinates index) {
        return new IndicesTemplate(this.client.indices(), this.getClusterTemplate(), this.elasticsearchConverter, index);
    }

    public ClusterOperations cluster() {
        return this.getClusterTemplate();
    }

    private ClusterTemplate getClusterTemplate() {
        return new ClusterTemplate(this.client.cluster(), this.elasticsearchConverter);
    }

    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequest getRequest = this.requestConverter.documentGetRequest(this.elasticsearchConverter.convertId((Object)id), this.routingResolver.getRouting(), index);
        GetResponse getResponse = this.execute(client -> client.get(getRequest, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        return (T)callback.doWith(DocumentAdapters.from((GetResult<EntityAsMap>)getResponse));
    }

    public <T> List<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        MgetRequest request = this.requestConverter.documentMgetRequest(query, clazz, index);
        MgetResponse result = this.execute(client -> client.mget(request, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        return DocumentAdapters.from((MgetResponse<EntityAsMap>)result).stream().map(multiGetItem -> MultiGetItem.of(multiGetItem.isFailed() ? null : callback.doWith((Document)multiGetItem.getItem()), (MultiGetItem.Failure)multiGetItem.getFailure())).collect(Collectors.toList());
    }

    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull((Object)bulkOptions, (String)"bulkOptions must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    public ByQueryResponse delete(DeleteQuery query, Class<?> clazz) {
        return this.delete(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    public ByQueryResponse delete(DeleteQuery query, Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        DeleteByQueryRequest request = this.requestConverter.documentDeleteByQueryRequest(query, this.routingResolver.getRouting(), clazz, index, this.getRefreshPolicy());
        DeleteByQueryResponse response = this.execute(client -> client.deleteByQuery(request));
        return this.responseConverter.byQueryResponse(response);
    }

    public ByQueryResponse delete(Query query, Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        DeleteByQueryRequest request = this.requestConverter.documentDeleteByQueryRequest(query, this.routingResolver.getRouting(), clazz, index, this.getRefreshPolicy());
        DeleteByQueryResponse response = this.execute(client -> client.deleteByQuery(request));
        return this.responseConverter.byQueryResponse(response);
    }

    public UpdateResponse update(UpdateQuery updateQuery, IndexCoordinates index) {
        UpdateRequest<Document, ?> request = this.requestConverter.documentUpdateRequest(updateQuery, index, this.getRefreshPolicy(), this.routingResolver.getRouting());
        org.opensearch.client.opensearch.core.UpdateResponse response = this.execute(client -> client.update(request, Document.class));
        return UpdateResponse.of((UpdateResponse.Result)TypeUtils.result(response.result()));
    }

    public ByQueryResponse updateByQuery(UpdateQuery updateQuery, IndexCoordinates index) {
        Assert.notNull((Object)updateQuery, (String)"updateQuery must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        UpdateByQueryRequest request = this.requestConverter.documentUpdateByQueryRequest(updateQuery, index, this.getRefreshPolicy());
        UpdateByQueryResponse byQueryResponse = this.execute(client -> client.updateByQuery(request));
        return this.responseConverter.byQueryResponse(byQueryResponse);
    }

    public String doIndex(IndexQuery query, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        IndexRequest<?> indexRequest = this.requestConverter.documentIndexRequest(query, indexCoordinates, this.refreshPolicy);
        IndexResponse indexResponse = this.execute(client -> client.index(indexRequest));
        Object queryObject = query.getObject();
        if (queryObject != null) {
            query.setObject(this.entityOperations.updateIndexedObject(queryObject, new IndexedObjectInformation(indexResponse.id(), indexResponse.index(), Long.valueOf(indexResponse.seqNo()), Long.valueOf(indexResponse.primaryTerm()), Long.valueOf(indexResponse.version())), this.elasticsearchConverter, this.routingResolver));
        }
        return indexResponse.id();
    }

    protected boolean doExists(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        ExistsRequest request = this.requestConverter.documentExistsRequest(id, this.routingResolver.getRouting(), index);
        return this.execute(client -> client.exists(request)).value();
    }

    protected String doDelete(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        DeleteRequest request = this.requestConverter.documentDeleteRequest(this.elasticsearchConverter.convertId((Object)id), routing, index, this.getRefreshPolicy());
        return this.execute(client -> client.delete(request)).id();
    }

    public ReindexResponse reindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        org.opensearch.client.opensearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, true);
        org.opensearch.client.opensearch.core.ReindexResponse reindexResponse = this.execute(client -> client.reindex(reindexRequestES));
        return this.responseConverter.reindexResponse(reindexResponse);
    }

    public String submitReindex(ReindexRequest reindexRequest) {
        org.opensearch.client.opensearch.core.ReindexRequest reindexRequestES = this.requestConverter.reindex(reindexRequest, false);
        org.opensearch.client.opensearch.core.ReindexResponse reindexResponse = this.execute(client -> client.reindex(reindexRequestES));
        if (reindexResponse.task() == null) {
            throw new UnsupportedBackendOperation("OpenSearchClient did not return a task id on submit request");
        }
        return reindexResponse.task();
    }

    public List<IndexedObjectInformation> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.requestConverter.documentBulkRequest(queries, bulkOptions, index, this.refreshPolicy);
        BulkResponse bulkResponse = this.execute(client -> client.bulk(bulkRequest));
        List<IndexedObjectInformation> indexedObjectInformationList = this.checkForBulkOperationFailure(bulkResponse);
        this.updateIndexedObjectsWithQueries(queries, indexedObjectInformationList);
        return indexedObjectInformationList;
    }

    public String getClusterVersion() {
        return this.execute(client -> client.info().version().number());
    }

    public String getVendor() {
        return "Elasticsearch";
    }

    public String getRuntimeLibraryVersion() {
        return Version.VERSION != null ? Version.VERSION.toString() : "0.0.0.?";
    }

    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, this.routingResolver.getRouting(), clazz, index, true);
        SearchResponse searchResponse = this.execute(client -> client.search(searchRequest, EntityAsMap.class));
        return searchResponse.hits().total().value();
    }

    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        if (query instanceof SearchTemplateQuery) {
            SearchTemplateQuery searchTemplateQuery = (SearchTemplateQuery)query;
            return this.doSearch(searchTemplateQuery, clazz, index);
        }
        return this.doSearch(query, clazz, index);
    }

    protected <T> SearchHits<T> doSearch(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.requestConverter.searchRequest(query, this.routingResolver.getRouting(), clazz, index, false);
        SearchResponse searchResponse = this.execute(client -> client.search(searchRequest, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback readDocumentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        SearchDocumentResponse.EntityCreator entityCreator = this.getEntityCreator(readDocumentCallback);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from((SearchResult<EntityAsMap>)searchResponse, entityCreator, this.jsonpMapper));
    }

    protected <T> SearchHits<T> doSearch(SearchTemplateQuery query, Class<T> clazz, IndexCoordinates index) {
        SearchTemplateRequest searchTemplateRequest = this.requestConverter.searchTemplate(query, this.routingResolver.getRouting(), index);
        SearchTemplateResponse searchTemplateResponse = this.execute(client -> client.searchTemplate(searchTemplateRequest, EntityAsMap.class));
        AbstractElasticsearchTemplate.ReadDocumentCallback readDocumentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        SearchDocumentResponse.EntityCreator entityCreator = this.getEntityCreator(readDocumentCallback);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from((SearchTemplateResponse<EntityAsMap>)searchTemplateResponse, entityCreator, this.jsonpMapper));
    }

    protected <T> SearchHits<T> doSearch(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.search((Query)((NativeQueryBuilder)NativeQuery.builder().withQuery(q -> q.moreLikeThis(this.requestConverter.moreLikeThisQuery(query, index))).withPageable(query.getPageable())).build(), clazz, index);
    }

    public <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        SearchRequest request = this.requestConverter.searchRequest(query, this.routingResolver.getRouting(), clazz, index, false, scrollTimeInMillis);
        SearchResponse response = this.execute(client -> client.search(request, EntityAsMap.class));
        return this.getSearchScrollHits(clazz, index, (SearchResult<EntityAsMap>)response);
    }

    public <T> SearchScrollHits<T> searchScrollContinue(String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)scrollId, (String)"scrollId must not be null");
        ScrollRequest request = ScrollRequest.of(sr -> sr.scrollId(scrollId).scroll(Time.of(t -> t.time(scrollTimeInMillis + "ms"))));
        ScrollResponse response = this.execute(client -> client.scroll(request, EntityAsMap.class));
        return this.getSearchScrollHits(clazz, index, (SearchResult<EntityAsMap>)response);
    }

    private <T> SearchScrollHits<T> getSearchScrollHits(Class<T> clazz, IndexCoordinates index, SearchResult<EntityAsMap> response) {
        AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback), this.jsonpMapper));
    }

    public void searchScrollClear(List<String> scrollIds) {
        Assert.notNull(scrollIds, (String)"scrollIds must not be null");
        if (!scrollIds.isEmpty()) {
            ClearScrollRequest request = ClearScrollRequest.of(csr -> csr.scrollId(scrollIds));
            this.execute(client -> client.clearScroll(request));
        }
    }

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        int size = queries.size();
        return this.multiSearch(queries, Collections.nCopies(size, clazz), Collections.nCopies(size, index)).stream().map(searchHits -> searchHits).collect(Collectors.toList());
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        return this.multiSearch(queries, classes, classes.stream().map(arg_0 -> ((OpenSearchTemplate)this).getIndexCoordinatesFor(arg_0)).toList());
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        return this.multiSearch(queries, classes, Collections.nCopies(queries.size(), index));
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, List<IndexCoordinates> indexes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull(indexes, (String)"indexes must not be null");
        Assert.isTrue((queries.size() == classes.size() && queries.size() == indexes.size() ? 1 : 0) != 0, (String)"queries, classes and indexes must have the same size");
        ArrayList<MultiSearchQueryParameter> multiSearchQueryParameters = new ArrayList<MultiSearchQueryParameter>(queries.size());
        Iterator<Class<?>> it = classes.iterator();
        Iterator<IndexCoordinates> indexesIt = indexes.iterator();
        Assert.isTrue((!queries.isEmpty() ? 1 : 0) != 0, (String)"queries should have at least 1 query");
        boolean isSearchTemplateQuery = queries.get(0) instanceof SearchTemplateQuery;
        for (Query query : queries) {
            Assert.isTrue((query instanceof SearchTemplateQuery == isSearchTemplateQuery ? 1 : 0) != 0, (String)"SearchTemplateQuery can't be mixed with other types of query in multiple search");
            Class<?> clazz = it.next();
            IndexCoordinates index = indexesIt.next();
            multiSearchQueryParameters.add(new MultiSearchQueryParameter(query, clazz, index));
        }
        return this.multiSearch(multiSearchQueryParameters, isSearchTemplateQuery);
    }

    private List<SearchHits<?>> multiSearch(List<MultiSearchQueryParameter> multiSearchQueryParameters, boolean isSearchTemplateQuery) {
        return isSearchTemplateQuery ? this.doMultiTemplateSearch(multiSearchQueryParameters.stream().map(p -> new MultiSearchTemplateQueryParameter((SearchTemplateQuery)p.query, p.clazz, p.index)).toList()) : this.doMultiSearch(multiSearchQueryParameters);
    }

    private List<SearchHits<?>> doMultiTemplateSearch(List<MultiSearchTemplateQueryParameter> mSearchTemplateQueryParameters) {
        MsearchTemplateRequest request = this.requestConverter.searchMsearchTemplateRequest(mSearchTemplateQueryParameters, this.routingResolver.getRouting());
        MsearchTemplateResponse response = this.execute(client -> client.msearchTemplate(request, EntityAsMap.class));
        List responseItems = response.responses();
        Assert.isTrue((mSearchTemplateQueryParameters.size() == responseItems.size() ? 1 : 0) != 0, (String)"number of response items does not match number of requests");
        int size = mSearchTemplateQueryParameters.size();
        List<Class<?>> classes = mSearchTemplateQueryParameters.stream().map(MultiSearchTemplateQueryParameter::clazz).collect(Collectors.toList());
        List<IndexCoordinates> indices = mSearchTemplateQueryParameters.stream().map(MultiSearchTemplateQueryParameter::index).collect(Collectors.toList());
        return this.getSearchHitsFromMsearchResponse(size, classes, indices, responseItems);
    }

    private List<SearchHits<?>> doMultiSearch(List<MultiSearchQueryParameter> multiSearchQueryParameters) {
        MsearchRequest request = this.requestConverter.searchMsearchRequest(multiSearchQueryParameters, this.routingResolver.getRouting());
        MsearchResponse msearchResponse = this.execute(client -> client.msearch(request, EntityAsMap.class));
        List responseItems = msearchResponse.responses();
        Assert.isTrue((multiSearchQueryParameters.size() == responseItems.size() ? 1 : 0) != 0, (String)"number of response items does not match number of requests");
        int size = multiSearchQueryParameters.size();
        List<Class<?>> classes = multiSearchQueryParameters.stream().map(MultiSearchQueryParameter::clazz).collect(Collectors.toList());
        List<IndexCoordinates> indices = multiSearchQueryParameters.stream().map(MultiSearchQueryParameter::index).collect(Collectors.toList());
        return this.getSearchHitsFromMsearchResponse(size, classes, indices, responseItems);
    }

    private List<SearchHits<?>> getSearchHitsFromMsearchResponse(int size, List<Class<?>> classes, List<IndexCoordinates> indices, List<MultiSearchResponseItem<EntityAsMap>> responseItems) {
        ArrayList searchHitsList = new ArrayList(size);
        Iterator<Class<?>> clazzIter = classes.iterator();
        Iterator<IndexCoordinates> indexIter = indices.iterator();
        Iterator<MultiSearchResponseItem<EntityAsMap>> responseIterator = responseItems.iterator();
        while (clazzIter.hasNext() && indexIter.hasNext()) {
            MultiSearchResponseItem<EntityAsMap> responseItem = responseIterator.next();
            if (responseItem.isResult()) {
                Class<?> clazz = clazzIter.next();
                IndexCoordinates index = indexIter.next();
                AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
                AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
                SearchHits searchHits = (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from((SearchResult<EntityAsMap>)responseItem.result(), this.getEntityCreator(documentCallback), this.jsonpMapper));
                searchHitsList.add(searchHits);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn((Object)String.format("multisearch response contains failure: %s", responseItem.failure().error().reason()));
        }
        return searchHitsList;
    }

    public String openPointInTime(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull((Object)keepAlive, (String)"keepAlive must not be null");
        Assert.notNull((Object)ignoreUnavailable, (String)"ignoreUnavailable must not be null");
        CreatePitRequest request = this.requestConverter.searchOpenPointInTimeRequest(index, keepAlive, ignoreUnavailable);
        return this.execute(client -> client.createPit(request)).pitId();
    }

    public Boolean closePointInTime(String pit) {
        Assert.notNull((Object)pit, (String)"pit must not be null");
        DeletePitRequest request = this.requestConverter.searchClosePointInTime(pit);
        DeletePitResponse response = this.execute(client -> client.deletePit(request));
        return !response.pits().isEmpty();
    }

    public boolean putScript(Script script) {
        Assert.notNull((Object)script, (String)"script must not be null");
        PutScriptRequest request = this.requestConverter.scriptPut(script);
        return this.execute(client -> client.putScript(request)).acknowledged();
    }

    @Nullable
    public Script getScript(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        GetScriptRequest request = this.requestConverter.scriptGet(name);
        return this.responseConverter.scriptResponse(this.execute(client -> client.getScript(request)));
    }

    public boolean deleteScript(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        DeleteScriptRequest request = this.requestConverter.scriptDelete(name);
        return this.execute(client -> client.deleteScript(request)).acknowledged();
    }

    public <T> T execute(ClientCallback<T> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.exceptionTranslator.translateException(e);
        }
    }

    public Query matchAllQuery() {
        return NativeQuery.builder().withQuery(qb -> qb.matchAll(mab -> mab)).build();
    }

    public Query idsQuery(List<String> ids) {
        return NativeQuery.builder().withQuery(qb -> qb.ids(iq -> iq.values(ids))).build();
    }

    public BaseQueryBuilder queryBuilderWithIds(List<String> ids) {
        return NativeQuery.builder().withIds(ids);
    }

    protected List<IndexedObjectInformation> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.errors()) {
            HashMap<String, BulkFailureException.FailureDetails> failedDocuments = new HashMap<String, BulkFailureException.FailureDetails>();
            for (BulkResponseItem item2 : bulkResponse.items()) {
                if (item2.error() == null) continue;
                failedDocuments.put(item2.id(), new BulkFailureException.FailureDetails(Integer.valueOf(item2.status()), item2.error().reason()));
            }
            throw new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
        return bulkResponse.items().stream().map(item -> new IndexedObjectInformation(item.id(), item.index(), item.seqNo(), item.primaryTerm(), item.version())).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface ClientCallback<T> {
        public T doWithClient(OpenSearchClient var1) throws IOException;
    }

    record MultiSearchQueryParameter(Query query, Class<?> clazz, IndexCoordinates index) {
    }

    record MultiSearchTemplateQueryParameter(SearchTemplateQuery query, Class<?> clazz, IndexCoordinates index) {
    }
}

